/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenuBackgroundDelegate;

public class SubstancePopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstancePopupMenuSeparatorUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Graphics2D graphics = (Graphics2D)g2.create();
        JSeparator sep = (JSeparator)c;
        int xOffset = MenuUtilities.getTextOffset(sep, sep.getParent());
        SubstanceMenuBackgroundDelegate.paintBackground(graphics, c, xOffset);
        Dimension s2 = c.getSize();
        int startX = 0;
        int width = s2.width;
        if (c.getComponentOrientation().isLeftToRight()) {
            startX = xOffset - 2;
            width = s2.width - startX;
        } else {
            startX = 0;
            width = xOffset > 0 ? xOffset - 4 : s2.width;
        }
        graphics.translate(startX, 0);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(sep));
        SeparatorPainterUtils.paintSeparator(sep, graphics, width, s2.height, sep.getOrientation(), true, 2);
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        return new Dimension(0, prefSize);
    }
}

