/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopShadowOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class MagellanSkin
extends SubstanceSkin {
    public static final String NAME = "Magellan";
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopLineOverlayPainter toolbarTopLineOverlayPainter;
    private TopShadowOverlayPainter footerTopShadowOverlayPainter;

    @Override
    public String getDisplayName() {
        return NAME;
    }

    public MagellanSkin() {
        SubstanceSkin.ColorSchemes colorSchemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/magellan.colorschemes");
        SubstanceColorScheme blueControlsActive = colorSchemes.get("Magellan Blue Controls Active");
        SubstanceColorScheme blueControlsEnabled = colorSchemes.get("Magellan Blue Controls Enabled");
        SubstanceColorSchemeBundle defaultColorSchemeBundle = new SubstanceColorSchemeBundle(blueControlsActive, blueControlsEnabled, blueControlsEnabled);
        defaultColorSchemeBundle.registerColorScheme(blueControlsEnabled, 0.5f, ComponentState.DISABLED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive, 0.5f, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme blueControlsActiveBorder = colorSchemes.get("Magellan Blue Controls Active Border");
        SubstanceColorScheme blueControlsEnabledBorder = colorSchemes.get("Magellan Blue Controls Enabled Border");
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsEnabledBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED, ComponentState.DISABLED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, 0.5f, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme blueControlsPressed = colorSchemes.get("Magellan Blue Controls Pressed");
        SubstanceColorScheme blueControlsPressedBorder = colorSchemes.get("Magellan Blue Controls Pressed Border");
        defaultColorSchemeBundle.registerColorScheme(blueControlsPressed, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsPressedBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        SubstanceColorScheme greenControls = colorSchemes.get("Magellan Green Controls");
        SubstanceColorScheme greenControlsMark = colorSchemes.get("Magellan Green Controls Mark");
        SubstanceColorScheme greenControlsBorder = colorSchemes.get("Magellan Green Controls Border");
        defaultColorSchemeBundle.registerColorScheme(greenControls, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(greenControlsMark, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(greenControlsBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        ComponentState uneditable = new ComponentState("uneditable", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.EDITABLE});
        SubstanceColorScheme uneditableControls = colorSchemes.get("Magellan Uneditable Controls");
        defaultColorSchemeBundle.registerColorScheme(uneditableControls, SubstanceSlices.ColorSchemeAssociationKind.FILL, uneditable);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerHighlightColorScheme(greenControls, 0.75f, ComponentState.ROLLOVER_UNSELECTED);
        defaultColorSchemeBundle.registerHighlightColorScheme(greenControls, 0.85f, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerHighlightColorScheme(greenControls, 0.95f, ComponentState.ROLLOVER_SELECTED);
        defaultColorSchemeBundle.registerHighlightColorScheme(greenControls, 1.0f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive.tint(0.2), SubstanceSlices.ColorSchemeAssociationKind.TAB, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        SubstanceColorScheme lightBlueBackground = colorSchemes.get("Magellan Light Blue Background");
        this.registerDecorationAreaSchemeBundle(defaultColorSchemeBundle, lightBlueBackground, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorScheme mediumBlueBackground = colorSchemes.get("Magellan Medium Blue Background");
        SubstanceColorScheme darkBlueBackground = colorSchemes.get("Magellan Dark Blue Background");
        this.registerAsDecorationArea(mediumBlueBackground, SubstanceSlices.DecorationAreaType.GENERAL, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.registerAsDecorationArea(darkBlueBackground, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        SubstanceColorScheme lightBlueControlsActive = colorSchemes.get("Magellan Light Blue Controls Active");
        SubstanceColorScheme lightBlueControlsEnabled = colorSchemes.get("Magellan Light Blue Controls Enabled");
        SubstanceColorScheme lightBlueBordersEnabled = colorSchemes.get("Magellan Light Blue Borders Enabled");
        SubstanceColorSchemeBundle footerColorSchemeBundle = new SubstanceColorSchemeBundle(lightBlueControlsActive, lightBlueControlsEnabled, lightBlueControlsEnabled);
        footerColorSchemeBundle.registerColorScheme(lightBlueControlsEnabled, 0.5f, ComponentState.DISABLED_UNSELECTED);
        footerColorSchemeBundle.registerColorScheme(lightBlueControlsActive, 0.5f, ComponentState.DISABLED_SELECTED);
        footerColorSchemeBundle.registerColorScheme(lightBlueBordersEnabled, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceColorScheme lightBlueSeparator = colorSchemes.get("Magellan Light Blue Separator");
        footerColorSchemeBundle.registerColorScheme(lightBlueSeparator, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme ultraLightBlueBackground = colorSchemes.get("Magellan Ultralight Blue Background");
        this.registerDecorationAreaSchemeBundle(footerColorSchemeBundle, ultraLightBlueBackground, SubstanceSlices.DecorationAreaType.FOOTER);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(scheme -> scheme.getUltraDarkColor());
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.toolbarTopLineOverlayPainter = new TopLineOverlayPainter(scheme -> SubstanceColorUtilities.getAlphaColor(scheme.getForegroundColor(), 40));
        this.addOverlayPainter(this.toolbarTopLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.footerTopShadowOverlayPainter = TopShadowOverlayPainter.getInstance();
        this.addOverlayPainter(this.footerTopShadowOverlayPainter, SubstanceSlices.DecorationAreaType.FOOTER);
        this.setTabFadeStart(0.18);
        this.setTabFadeEnd(0.18);
        FractionBasedBorderPainter outerBorderPainter = new FractionBasedBorderPainter("Magellan Outer", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.DARK});
        DelegateBorderPainter innerBorderPainter = new DelegateBorderPainter("Magellan Inner", new ClassicBorderPainter(), -1593835521, 0x60FFFFFF, 0x40FFFFFF, scheme -> scheme.tint(0.5));
        this.borderPainter = new CompositeBorderPainter(NAME, outerBorderPainter, innerBorderPainter);
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
        this.highlightPainter = new ClassicHighlightPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.buttonShaper = new ClassicButtonShaper();
    }
}

