/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class DerivedColorsResolverLight
implements SchemeDerivedColors {
    SubstanceColorScheme scheme;

    public DerivedColorsResolverLight(SubstanceColorScheme scheme) {
        if (scheme.isDark()) {
            throw new IllegalArgumentException("The scheme must be light: " + scheme.getDisplayName());
        }
        this.scheme = scheme;
    }

    @Override
    public Color getWatermarkStampColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getMidColor(), 50);
    }

    @Override
    public Color getWatermarkLightColor() {
        return this.scheme.getLightColor();
    }

    @Override
    public Color getWatermarkDarkColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getDarkColor(), 15);
    }

    @Override
    public Color getLineColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getDarkColor(), 0.7f);
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.scheme.getUltraDarkColor().darker().darker();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return this.scheme.getExtraLightColor();
    }

    public String toString() {
        return this.scheme.getDisplayName();
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.scheme.getExtraLightColor();
    }

    @Override
    public Color getFocusRingColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getForegroundColor(), 192);
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getUltraLightColor(), this.scheme.getExtraLightColor(), 0.8f);
    }
}

