/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import org.jire.swiftfup.client.FileChecksumsResponse;

public final class FileChecksumsResponseDecoder
extends ByteToMessageDecoder {
    private int size = -1;
    private Int2IntMap fileToChecksum;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.size == -1 || this.fileToChecksum == null) {
            if (!in.isReadable(3)) {
                return;
            }
            this.size = in.readUnsignedMedium();
            this.fileToChecksum = new Int2IntOpenHashMap(this.size);
        }
        if (!in.isReadable(7)) {
            return;
        }
        int filePair = in.readMedium();
        int crc32 = in.readInt();
        this.fileToChecksum.put(filePair, crc32);
        if (this.fileToChecksum.size() >= this.size) {
            FileChecksumsResponse response = new FileChecksumsResponse(this.fileToChecksum);
            out.add(response);
        }
    }
}

