/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import java.util.zip.Inflater;

public final class GZIPDecompressor {
    private final Inflater inflater = new Inflater(true);
    private final byte[] buffer;
    private static final ThreadLocal<GZIPDecompressor> threadLocal = ThreadLocal.withInitial(GZIPDecompressor::new);

    public GZIPDecompressor(byte[] buffer) {
        this.buffer = buffer;
    }

    public GZIPDecompressor() {
        this(new byte[999999]);
    }

    public byte[] decompress(byte[] input) {
        int outputLength = this.decompress(input, this.buffer);
        byte[] output = new byte[outputLength];
        System.arraycopy(this.buffer, 0, output, 0, outputLength);
        return output;
    }

    public int decompress(byte[] input, byte[] output) {
        int offset = this.calcOffset(input);
        int uncompressedBytes = -1;
        try {
            this.inflater.setInput(input, offset, input.length - offset - 8);
            uncompressedBytes = this.inflater.inflate(output);
        }
        catch (Exception exception) {
            this.inflater.reset();
            throw new RuntimeException("Invalid GZIP compressed data!");
        }
        this.inflater.reset();
        return uncompressedBytes;
    }

    public int calcOffset(byte[] input) {
        if (input[0] != 31 || input[1] != -117) {
            throw new RuntimeException("invalid gzip header");
        }
        byte flags = input[3];
        int offset = 10;
        if ((flags & 2) != 0) {
            offset += 2;
        }
        if ((flags & 4) != 0) {
            offset += 2;
        }
        if ((flags & 8) != 0) {
            while (input[offset++] != 0) {
            }
        }
        if ((flags & 0x10) != 0) {
            while (input[offset++] != 0) {
            }
        }
        if ((flags & 0x20) != 0) {
            offset += 12;
        }
        return offset;
    }

    public static GZIPDecompressor getInstance() {
        return threadLocal.get();
    }
}

