/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import org.jire.swiftfup.client.FileRequests;
import org.jire.swiftfup.client.codec.FileChecksumsRequestEncoder;
import org.jire.swiftfup.client.codec.FileChecksumsResponseDecoder;
import org.jire.swiftfup.client.codec.FileChecksumsResponseHandler;
import org.jire.swiftfup.client.codec.FileRequestEncoder;
import org.jire.swiftfup.client.codec.FileResponseDecoder;
import org.jire.swiftfup.client.codec.FileResponseHandler;

public final class FileClientChannelInitializer
extends ChannelInitializer<Channel> {
    private final FileRequests fileRequests;
    private final boolean reconnect;

    public FileClientChannelInitializer(FileRequests fileRequests, boolean reconnect) {
        this.fileRequests = fileRequests;
        this.reconnect = reconnect;
    }

    @Override
    protected void initChannel(Channel ch) {
        ByteToMessageDecoder decoder = this.reconnect ? new FileResponseDecoder() : new FileChecksumsResponseDecoder();
        MessageToByteEncoder encoder = this.reconnect ? new FileRequestEncoder() : new FileChecksumsRequestEncoder();
        SimpleChannelInboundHandler handler = this.reconnect ? new FileResponseHandler(this.fileRequests) : new FileChecksumsResponseHandler(this.fileRequests);
        ChannelPipeline p = ch.pipeline();
        p.addLast("decoder", (ChannelHandler)decoder);
        p.addLast("encoder", (ChannelHandler)encoder);
        p.addLast("handler", (ChannelHandler)handler);
        p.addLast(new ExceptionHandler());
    }

    private class ExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private ExceptionHandler() {
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ChannelId id = ctx.channel().id();
            if (cause instanceof Error) {
                ((FileClientChannelInitializer)FileClientChannelInitializer.this).fileRequests.requests.clear();
                System.out.println("Error caught at end of pipeline in channel " + id + ", interrupting!");
                cause.printStackTrace();
            } else {
                ((FileClientChannelInitializer)FileClientChannelInitializer.this).fileRequests.requests.clear();
                System.out.println("Exception caught at end of pipeline in channel " + id + ", interrupting!");
                cause.printStackTrace();
            }
        }
    }
}

