/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.jire.swiftfup.client.FileChecksumsRequest;
import org.jire.swiftfup.client.FileClientChannelInitializer;
import org.jire.swiftfup.client.FilePair;
import org.jire.swiftfup.client.FileRequest;
import org.jire.swiftfup.client.FileRequests;

public final class FileClient {
    private final FileRequests fileRequests;
    private final Bootstrap bootstrap;
    private volatile Channel channel;
    private volatile ObjectArrayList<Integer> errors = new ObjectArrayList();

    public FileClient(String host, int port, FileRequests fileRequests) {
        MultithreadEventLoopGroup group;
        this.fileRequests = fileRequests;
        int netThreads = 1;
        MultithreadEventLoopGroup multithreadEventLoopGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(netThreads) : (group = KQueue.isAvailable() ? new KQueueEventLoopGroup(netThreads) : new NioEventLoopGroup(netThreads));
        Class<EpollSocketChannel> channelClass = group instanceof EpollEventLoopGroup ? EpollSocketChannel.class : (group instanceof KQueueEventLoopGroup ? KQueueSocketChannel.class : NioSocketChannel.class);
        this.bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(channelClass)).group(group)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 120000)).option(ChannelOption.SO_TIMEOUT, 120000)).remoteAddress(host, port);
    }

    public FileRequests getFileRequests() {
        return this.fileRequests;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean isConnected(Channel channel) {
        return channel != null && channel.isOpen();
    }

    public Channel connect(boolean reconnect) {
        FileClientChannelInitializer handler = new FileClientChannelInitializer(this.getFileRequests(), reconnect);
        Channel channel = ((Bootstrap)this.bootstrap.handler(handler)).connect().syncUninterruptibly().channel();
        this.setChannel(channel);
        return channel;
    }

    public Channel connect() {
        return this.connect(false);
    }

    public Channel connectedChannel() {
        Channel channel = this.getChannel();
        return this.isConnected(channel) ? channel : this.connect(true);
    }

    public void flush() {
        Channel channel = this.getChannel();
        if (this.isConnected(channel)) {
            channel.flush();
        }
    }

    public void request(FileRequest fileRequest) {
        Channel channel = this.connectedChannel();
        channel.write(fileRequest, channel.voidPromise());
        fileRequest.sent();
    }

    public FileRequest request(int filePair) {
        return this.getFileRequests().filePair(filePair, this);
    }

    public FileRequest request(int index, int file) {
        return this.request(FilePair.create(index, file));
    }

    public void request(FileChecksumsRequest checksumsRequest) {
        Channel channel = this.connectedChannel();
        channel.write(checksumsRequest, channel.voidPromise());
    }

    public FileChecksumsRequest requestChecksums() {
        return this.getFileRequests().checksums(this);
    }

    public void error(int modelId) {
        this.errors.add(modelId);
    }

    public boolean containsError(int modelId) {
        if (this.errors.contains(modelId)) {
            this.errors.remove((Object)modelId);
            return true;
        }
        return false;
    }
}

