/*
 * Decompiled with CFR 0.152.
 */
package org.jire.swiftfup.client;

import java.util.concurrent.TimeUnit;
import org.jire.swiftfup.client.FileRequests;

public interface AutoProcessor {
    public boolean shouldAutoProcess(FileRequests var1);

    default public void autoProcess(FileRequests fileRequests) {
        long start = System.nanoTime();
        fileRequests.process();
        long end = System.nanoTime();
        long elapsed = end - start;
        long sleepTime = (long)this.sleepTime() - elapsed;
        long sleepTimeMillis = TimeUnit.NANOSECONDS.toMillis(sleepTime);
        if (sleepTimeMillis > 0L) {
            try {
                Thread.sleep(sleepTimeMillis);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    default public void autoProcessLoop(FileRequests fileRequests) {
        while (this.shouldAutoProcess(fileRequests)) {
            this.autoProcess(fileRequests);
        }
    }

    default public int sleepTime() {
        return 20;
    }
}

