/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jgroups.util.ByteArray;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public class Probe {
    protected final Set<String> senders = new HashSet<String>();
    protected boolean weed_out_duplicates;
    protected String match;
    protected static final int DEFAULT_DIAG_PORT = 7500;
    protected static final String MEMBER_ADDRS = "member-addrs";
    protected ExecutorService thread_pool;
    protected final List<Requester> requesters = new ArrayList<Requester>();
    protected final AtomicInteger matched = new AtomicInteger();
    protected final AtomicInteger not_matched = new AtomicInteger();
    protected final AtomicInteger count = new AtomicInteger();
    protected boolean verbose;
    protected static final String PREFIX = "**";

    public boolean verbose() {
        return this.verbose;
    }

    public Probe verbose(boolean b) {
        this.verbose = b;
        return this;
    }

    public void start(List<InetAddress> addrs, InetAddress bind_addr, int port, int ttl, long timeout2, String request, String match, boolean weed_out_duplicates, String passcode, boolean udp, boolean tcp) throws Exception {
        this.weed_out_duplicates = weed_out_duplicates;
        this.match = match;
        this.thread_pool = Executors.newCachedThreadPool(new DefaultThreadFactory("probe", true, true));
        if (this.verbose) {
            System.out.printf("%s addrs: %s\n%s udp: %b, tcp: %b\n\n", PREFIX, addrs, PREFIX, udp, tcp);
        }
        for (InetAddress addr : addrs) {
            boolean unicast_dest;
            boolean bl = unicast_dest = addr != null && !addr.isMulticastAddress();
            if (unicast_dest) {
                this.fetchAddressesAndInvoke(new InetSocketAddress(addr, port), bind_addr, request, passcode, timeout2, ttl, udp, tcp);
                continue;
            }
            Object req = new UdpRequester(new InetSocketAddress(addr, port), request, passcode, null).start(bind_addr, timeout2, ttl);
            this.requesters.add((Requester)req);
            this.thread_pool.execute((Runnable)req);
        }
        Util.sleep(timeout2);
        this.requesters.forEach(Requester::stop);
        this.thread_pool.shutdown();
        this.thread_pool.awaitTermination(timeout2, TimeUnit.MILLISECONDS);
        System.out.printf("%d responses (%d matches, %d non matches)\n", this.count.get(), this.matched.get(), this.not_matched.get());
    }

    protected void fetchAddressesAndInvoke(SocketAddress dest, InetAddress bind_addr, String request, String passcode, long timeout2, int ttl, boolean udp, boolean tcp) throws IOException {
        Object r;
        Consumer<ByteArray> on_rsp_handler = buf -> {
            String response = new String(buf.getArray(), 0, buf.getLength());
            try {
                Collection<SocketAddress> targets = Probe.parseAddresses(response, ((InetSocketAddress)dest).getPort());
                if (targets == null || targets.isEmpty()) {
                    return;
                }
                for (SocketAddress target : targets) {
                    Object req;
                    if (udp) {
                        if (this.verbose) {
                            System.out.printf("%s sending UDP request to %s\n", PREFIX, target);
                        }
                        req = new UdpRequester(target, request, passcode, null).start(bind_addr, timeout2, ttl);
                        ((Requester)req).run();
                    }
                    if (!tcp) continue;
                    if (this.verbose) {
                        System.out.printf("%s sending TCP request to %s\n", PREFIX, target);
                    }
                    req = new TcpRequester(target, request, passcode, null).start(bind_addr, timeout2, ttl);
                    ((Requester)req).run();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
        if (udp) {
            r = new UdpRequester(dest, MEMBER_ADDRS, passcode, on_rsp_handler).start(bind_addr, timeout2, ttl);
            this.requesters.add((Requester)r);
            this.thread_pool.execute((Runnable)r);
        }
        if (tcp) {
            r = new TcpRequester(dest, MEMBER_ADDRS, passcode, on_rsp_handler).start(bind_addr, timeout2, ttl);
            this.requesters.add((Requester)r);
            this.thread_pool.execute((Runnable)r);
        }
    }

    protected static Collection<SocketAddress> parseAddresses(String input, int port) throws Exception {
        String ADDRS = "member-addrs=";
        ConcurrentHashMap<InetAddress, Integer> map = new ConcurrentHashMap<InetAddress, Integer>();
        ArrayList<SocketAddress> retval = new ArrayList<SocketAddress>();
        int start_index = -1;
        int end_index = -1;
        if (input != null && (start_index = input.indexOf("member-addrs=")) >= 0) {
            end_index = (input = input.substring(start_index + "member-addrs=".length()).trim()).indexOf(10);
            if (end_index > 0) {
                input = input.substring(0, end_index);
            }
            List<String> rsps = Util.parseStringList(input, ",");
            for (String tmp : rsps) {
                InetAddress key;
                Integer val;
                int index2 = tmp.lastIndexOf(58);
                if (index2 != -1) {
                    tmp = tmp.substring(0, index2);
                }
                if ((val = map.putIfAbsent(key = InetAddress.getByName(tmp), 1)) == null) continue;
                map.put(key, val + 1);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            InetAddress key = (InetAddress)entry.getKey();
            int val = (Integer)entry.getValue();
            for (int j = 0; j < val; ++j) {
                retval.add(new InetSocketAddress(key, port + j));
            }
        }
        return retval;
    }

    private boolean checkDuplicateResponse(String response) {
        int index = response.indexOf("local_addr");
        if (index != -1) {
            String addr = Probe.parseAddress(response.substring(index + 1 + "local_addr".length()));
            return !this.senders.add(addr);
        }
        return false;
    }

    private static String parseAddress(String response) {
        StringTokenizer st = new StringTokenizer(response);
        return st.nextToken();
    }

    private static boolean matches(String response, String match) {
        if (response == null) {
            return false;
        }
        if (match == null) {
            return true;
        }
        int index = response.indexOf(match);
        return index > -1;
    }

    public static void main(String[] args2) throws Exception {
        int i;
        InetAddress bind_addr = null;
        StackType ip_version = Util.getIpStackType();
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        int port = 0;
        int ttl = 32;
        long timeout2 = 500L;
        StringBuilder request = new StringBuilder();
        String match = null;
        boolean weed_out_duplicates = false;
        boolean udp = true;
        boolean tcp = false;
        boolean verbose = false;
        String passcode = null;
        for (i = 0; i < args2.length; ++i) {
            if ("-addr".equals(args2[i])) {
                InetAddress addr;
                if ((addr = Util.getByName(args2[++i], ip_version)) instanceof Inet6Address) {
                    ip_version = StackType.IPv6;
                }
                addrs.add(addr);
                args2[i - 1] = null;
                args2[i] = null;
                continue;
            }
            if ("-bind_addr".equals(args2[i])) {
                if ((bind_addr = Util.getByName(args2[++i], ip_version)) instanceof Inet6Address) {
                    ip_version = StackType.IPv6;
                }
                args2[i - 1] = null;
                args2[i] = null;
                continue;
            }
            if ("-4".equals(args2[i])) {
                ip_version = StackType.IPv4;
                args2[i] = null;
                continue;
            }
            if ("-6".equals(args2[i])) {
                ip_version = StackType.IPv6;
                args2[i] = null;
                continue;
            }
            if (!"-v".equals(args2[i])) continue;
            verbose = true;
            args2[i] = null;
        }
        try {
            for (i = 0; i < args2.length; ++i) {
                if (args2[i] == null) continue;
                if ("-port".equals(args2[i])) {
                    port = Integer.parseInt(args2[++i]);
                    continue;
                }
                if ("-ttl".equals(args2[i])) {
                    ttl = Integer.parseInt(args2[++i]);
                    continue;
                }
                if ("-timeout".equals(args2[i])) {
                    timeout2 = Long.parseLong(args2[++i]);
                    continue;
                }
                if ("-match".equals(args2[i])) {
                    match = args2[++i];
                    continue;
                }
                if ("-weed_out_duplicates".equals(args2[i])) {
                    weed_out_duplicates = true;
                    continue;
                }
                if ("-passcode".equals(args2[i])) {
                    passcode = args2[++i];
                    continue;
                }
                if ("-cluster".equals(args2[i])) {
                    String cluster = args2[++i];
                    request.append("cluster=" + cluster + " ");
                    continue;
                }
                if ("-udp".equals(args2[i])) {
                    udp = Boolean.parseBoolean(args2[++i]);
                    continue;
                }
                if ("-tcp".equals(args2[i])) {
                    tcp = Boolean.parseBoolean(args2[++i]);
                    continue;
                }
                if ("-help".equals(args2[i]) || "-h".equals(args2[i]) || "--help".equals(args2[i])) {
                    Probe.help();
                    return;
                }
                request.append(args2[i] + " ");
            }
            if (!udp && !tcp) {
                throw new IllegalArgumentException("either UDP or TCP mode has to be enabled");
            }
            if (tcp) {
                udp = false;
            }
            if (ip_version == StackType.IPv6 && bind_addr == null) {
                bind_addr = Util.getLoopback(ip_version);
            }
            Probe p = new Probe().verbose(verbose);
            if (addrs.isEmpty()) {
                InetAddress local;
                InetAddress mcast_addr;
                if (udp && !addrs.contains(mcast_addr = InetAddress.getByName(ip_version == StackType.IPv6 ? "ff0e::0:75:75" : "224.0.75.75"))) {
                    addrs.add(mcast_addr);
                }
                if (tcp && (local = Util.getNonLoopbackAddress()) != null && !addrs.contains(local)) {
                    addrs.add(local);
                }
            }
            if (port == 0) {
                port = 7500;
            }
            p.start(addrs, bind_addr, port, ttl, timeout2, request.toString(), match, weed_out_duplicates, passcode, udp, tcp);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static void help() {
        System.out.println("Probe [-help] [-addr <addr>] [-4] [-6] [-bind_addr <addr>] [-port <port>] [-ttl <ttl>] [-timeout <timeout>] [-passcode <code>] [-weed_out_duplicates] [-cluster regexp-pattern] [-match pattern] [-udp true|false] [-tcp true|false] [-v] [key[=value]]*\n\nExamples:\nprobe.sh keys // dumps all valid commands\nprobe.sh jmx=NAKACK // dumps JMX info about all NAKACK protocols\nprobe.sh op=STABLE.runMessageGarbageCollection // invokes the method in all STABLE protocols\nprobe.sh jmx=UDP.oob,thread_pool // dumps all attrs of UDP starting with oob* or thread_pool*\nprobe.sh jmx=FLUSH.bypass=true\n");
    }

    protected class TcpRequester
    extends Requester {
        protected Socket sock;
        protected InputStream in;
        protected OutputStream out;

        protected TcpRequester(SocketAddress dest, String request, String passcode, Consumer<ByteArray> on_rsp) {
            super(dest, request, passcode, on_rsp);
        }

        @Override
        protected <T extends Requester> T start(InetAddress bind_addr, long timeout2, int ttl) throws IOException {
            this.sock = new Socket();
            this.sock.setSoTimeout((int)timeout2);
            this.sock.bind(new InetSocketAddress(bind_addr, 0));
            this.sock.connect(this.dest);
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
            return (T)this;
        }

        @Override
        protected <T extends Requester> T stop() {
            Util.close(this.sock, this.in, this.out);
            return (T)this;
        }

        @Override
        protected boolean isRunning() {
            return this.sock != null && !this.sock.isClosed();
        }

        @Override
        protected <T extends Requester> T sendRequest(byte[] request) throws IOException {
            this.out.write(request);
            this.out.write(10);
            return (T)this;
        }

        @Override
        protected ByteArray fetchResponse() {
            byte[] buf = new byte[1024];
            int index = 0;
            try {
                while (true) {
                    int bytes_read;
                    if ((bytes_read = this.in.read(buf, index, buf.length - index)) == -1) {
                        if (index <= 0) {
                            return null;
                        }
                        break;
                    }
                    if ((index += bytes_read) < buf.length) continue;
                    byte[] tmp = new byte[buf.length + 1024];
                    System.arraycopy(buf, 0, tmp, 0, index);
                    buf = tmp;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return new ByteArray(buf, 0, index);
        }
    }

    protected class UdpRequester
    extends Requester {
        protected MulticastSocket sock;
        protected final byte[] buf;

        protected UdpRequester(SocketAddress dest, String request, String passcode, Consumer<ByteArray> on_rsp) {
            super(dest, request, passcode, on_rsp);
            this.buf = new byte[70000];
        }

        @Override
        protected <T extends Requester> T start(InetAddress bind_addr, long timeout2, int ttl) throws IOException {
            this.sock = new MulticastSocket();
            this.sock.setSoTimeout((int)timeout2);
            this.sock.setTimeToLive(ttl);
            if (bind_addr != null) {
                this.sock.setNetworkInterface(NetworkInterface.getByInetAddress(bind_addr));
            }
            return (T)this;
        }

        @Override
        protected <T extends Requester> T stop() {
            Util.close((Closeable)this.sock);
            return (T)this;
        }

        @Override
        protected boolean isRunning() {
            return this.sock != null && !this.sock.isClosed();
        }

        @Override
        protected <T extends Requester> T sendRequest(byte[] request) throws IOException {
            DatagramPacket probe = new DatagramPacket(request, 0, request.length, this.dest);
            this.sock.send(probe);
            return (T)this;
        }

        @Override
        protected ByteArray fetchResponse() {
            DatagramPacket rsp = new DatagramPacket(this.buf, 0, this.buf.length);
            try {
                this.sock.receive(rsp);
                return new ByteArray(rsp.getData(), 0, rsp.getLength());
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    protected abstract class Requester
    implements Runnable {
        protected final SocketAddress dest;
        protected final String request;
        protected final String passcode;
        protected Consumer<ByteArray> on_rsp;
        protected final Consumer<ByteArray> ON_RSP = buf -> {
            if (buf == null) {
                System.out.println("\n");
                return;
            }
            String response = new String(buf.getArray(), 0, buf.getLength());
            if (Probe.this.weed_out_duplicates && Probe.this.checkDuplicateResponse(response)) {
                return;
            }
            Probe.this.count.incrementAndGet();
            if (Probe.matches(response, Probe.this.match)) {
                Probe.this.matched.incrementAndGet();
                System.out.printf("#%d (%d bytes):\n%s\n", Probe.this.count.get(), buf.getLength(), response);
            } else {
                Probe.this.not_matched.incrementAndGet();
            }
        };

        protected Requester(SocketAddress dest, String request, String passcode, Consumer<ByteArray> on_rsp) {
            this.dest = dest;
            this.request = request;
            this.passcode = passcode;
            this.on_rsp = on_rsp != null ? on_rsp : this.ON_RSP;
        }

        protected abstract <T extends Requester> T start(InetAddress var1, long var2, int var4) throws IOException;

        protected abstract <T extends Requester> T stop();

        protected abstract boolean isRunning();

        protected abstract <T extends Requester> T sendRequest(byte[] var1) throws IOException;

        protected abstract ByteArray fetchResponse();

        protected <T extends Requester> T setResponseHandler(Consumer<ByteArray> rh) {
            this.on_rsp = rh;
            return (T)this;
        }

        @Override
        public void run() {
            try {
                ByteArray data;
                byte[] req = this.createRequest();
                this.sendRequest(req);
                while (this.isRunning() && (data = this.fetchResponse()) != null) {
                    if (this.on_rsp == null) continue;
                    this.on_rsp.accept(data);
                }
            }
            catch (Throwable t) {
                System.err.printf("failed sending request to %s: %s\n", this.dest, t);
            }
        }

        protected byte[] createRequest() throws IOException, NoSuchAlgorithmException {
            byte[] queryPayload;
            byte[] authenticationDigest = null;
            if (this.passcode != null) {
                long t1 = new Date().getTime();
                double q1 = Math.random();
                authenticationDigest = Util.createAuthenticationDigest(this.passcode, t1, q1);
            }
            byte[] payload = queryPayload = this.request.getBytes();
            if (authenticationDigest != null) {
                payload = new byte[authenticationDigest.length + queryPayload.length];
                System.arraycopy(authenticationDigest, 0, payload, 0, authenticationDigest.length);
                System.arraycopy(queryPayload, 0, payload, authenticationDigest.length, queryPayload.length);
            }
            return payload;
        }
    }
}

