/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ws;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.runelite.client.RuneLite;
import net.runelite.client.eventbus.EventBus;
import net.runelite.http.api.ws.WebsocketGsonFactory;
import net.runelite.http.api.ws.WebsocketMessage;
import net.runelite.http.api.ws.messages.Handshake;
import net.runelite.http.api.ws.messages.party.PartyMessage;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WSClient
extends WebSocketListener
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(WSClient.class);
    private final EventBus eventBus;
    private final OkHttpClient okHttpClient;
    private final HttpUrl runeliteWs;
    private final Collection<Class<? extends WebsocketMessage>> messages = new HashSet<Class<? extends WebsocketMessage>>();
    private volatile Gson gson;
    private UUID sessionId;
    private WebSocket webSocket;

    @Inject
    private WSClient(EventBus eventBus, OkHttpClient okHttpClient, @Named(value="runelite.ws") HttpUrl runeliteWs) {
        this.eventBus = eventBus;
        this.okHttpClient = okHttpClient;
        this.runeliteWs = runeliteWs;
        this.gson = WebsocketGsonFactory.build(WebsocketGsonFactory.factory(this.messages));
    }

    public boolean sessionExists() {
        return this.sessionId != null;
    }

    public void changeSession(UUID sessionId) {
        if (Objects.equals(sessionId, this.sessionId)) {
            return;
        }
        if (this.webSocket != null) {
            this.close();
            this.webSocket = null;
        }
        this.sessionId = sessionId;
        if (sessionId != null) {
            this.connect();
        }
    }

    private void connect() {
        if (this.sessionId == null) {
            throw new IllegalStateException("Cannot connect with no session id");
        }
        Request request = new Request.Builder().url(this.runeliteWs).header("User-Agent", RuneLite.USER_AGENT).build();
        this.webSocket = this.okHttpClient.newWebSocket(request, this);
        Handshake handshake2 = new Handshake();
        handshake2.setSession(this.sessionId);
        this.send(handshake2);
    }

    public void registerMessage(Class<? extends WebsocketMessage> message) {
        if (this.messages.add(message)) {
            this.gson = WebsocketGsonFactory.build(WebsocketGsonFactory.factory(this.messages));
        }
    }

    public void unregisterMessage(Class<? extends WebsocketMessage> message) {
        if (this.messages.remove(message)) {
            this.gson = WebsocketGsonFactory.build(WebsocketGsonFactory.factory(this.messages));
        }
    }

    public void send(WebsocketMessage message) {
        if (this.webSocket == null) {
            log.debug("Reconnecting to server");
            this.connect();
        }
        String json = this.gson.toJson((Object)message, (Type)((Object)WebsocketMessage.class));
        this.webSocket.send(json);
        log.debug("Sent: {}", (Object)json);
    }

    @Override
    public void close() {
        if (this.webSocket != null) {
            this.webSocket.close(1000, null);
        }
    }

    @Override
    public void onOpen(WebSocket webSocket, Response response) {
        log.info("Websocket {} opened", (Object)webSocket);
    }

    @Override
    public void onMessage(WebSocket webSocket, String text) {
        WebsocketMessage message;
        try {
            message = this.gson.fromJson(text, WebsocketMessage.class);
        }
        catch (JsonParseException e) {
            log.debug("Failed to deserialize message", e);
            return;
        }
        if (message.isParty() && !(message instanceof PartyMessage)) {
            return;
        }
        log.debug("Got: {}", (Object)text);
        this.eventBus.post(message);
    }

    @Override
    public void onClosed(WebSocket webSocket, int code, String reason) {
        log.info("Websocket {} closed: {}/{}", webSocket, code, reason);
        this.webSocket = null;
    }

    @Override
    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        log.warn("Error in websocket: {}", (Object)response, (Object)t);
        this.webSocket = null;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }
}

