/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.runelite.client.RuneLiteProperties;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogService {
    private static final Logger log = LoggerFactory.getLogger(LogService.class);
    private static final String SERVICE_URL_DEFINES_IP = "https://api.ipify.org";
    private static final String ERROR_LOGS_API_ENDPOINT = "https://ecm.legion-ent.com/api/v1/logs/create-client-error-no-auth";
    private static final String ERROR_TEMP_FILE_LOCATION = "logs/error-temp.log";
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final OkHttpClient client = new OkHttpClient();

    public CompletableFuture<Void> processSendingErrorLogs() {
        return CompletableFuture.runAsync(() -> {
            try {
                String logs = this.readLogs();
                if (logs != null && !logs.isEmpty()) {
                    this.sendErrorLogsToApi(logs);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, this.executorService);
    }

    private String readLogs() throws IOException {
        Path filePath = Paths.get(ERROR_TEMP_FILE_LOCATION, new String[0]);
        return Files.readString(filePath);
    }

    private void sendErrorLogsToApi(String logs) {
        String version = RuneLiteProperties.getVersion();
        FormBody formBody = new FormBody.Builder().add("username", "test").add("cache_version", version).add("error_body", logs).add("project_id", "4").add("ip_address", this.getIpAddress()).build();
        Request request = new Request.Builder().url(ERROR_LOGS_API_ENDPOINT).post(formBody).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) {
                log.info("Error logs sent successfully: " + response.message());
            } else {
                log.error("Failed to send  Error logs: " + response.message());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
        if (this.client.cache() != null) {
            try {
                this.client.cache().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getIpAddress() {
        Request request = new Request.Builder().url(SERVICE_URL_DEFINES_IP).build();
        Response response = this.client.newCall(request).execute();
        try {
            String string = response.body().string();
            if (response != null) {
                response.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Couldn't fetch IP address. " + e);
                return "undefined IP address";
            }
        }
    }
}

