/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class GpuIntBuffer {
    private IntBuffer buffer = GpuIntBuffer.allocateDirect(65536);

    public void put(int x, int y, int z) {
        this.buffer.put(x).put(y).put(z);
    }

    public void put(int x, int y, int z, int c) {
        this.buffer.put(x).put(y).put(z).put(c);
    }

    public void put(int[] ints) {
        this.buffer.put(ints);
    }

    public void flip() {
        this.buffer.flip();
    }

    public void clear() {
        this.buffer.clear();
    }

    public GpuIntBuffer ensureCapacity(int size) {
        int position;
        int capacity = this.buffer.capacity();
        if (capacity - (position = this.buffer.position()) < size) {
            while ((capacity *= 2) - position < size) {
            }
            IntBuffer newB = GpuIntBuffer.allocateDirect(capacity);
            this.buffer.flip();
            newB.put(this.buffer);
            this.buffer = newB;
        }
        return this;
    }

    public IntBuffer getBuffer() {
        return this.buffer;
    }

    public static IntBuffer allocateDirect(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }
}

