/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FileWatcher.class);
    Thread watchThread;
    WatchService watchService;
    HashMap<WatchKey, Path> watchKeys = new HashMap();
    HashMap<Integer, BiConsumer<Path, WatchEvent<Path>>> changeHandlers = new HashMap();
    private static final WatchEvent.Kind<?>[] eventKinds = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};

    public FileWatcher() throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.watchThread = new Thread(() -> {
            try {
                WatchKey key;
                while ((key = this.watchService.take()) != null) {
                    Path watchPath = this.watchKeys.get(key);
                    if (watchPath == null || !watchPath.toFile().exists()) continue;
                    boolean singleFile = watchPath.toFile().isFile();
                    Path dir = singleFile ? watchPath.getParent() : watchPath;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path path = dir.resolve((Path)event.context());
                        if (singleFile && path.compareTo(watchPath) != 0) continue;
                        this.changeHandlers.values().forEach(cb -> cb.accept(path, event));
                    }
                    key.reset();
                }
            }
            catch (InterruptedException | ClosedWatchServiceException exception) {
                // empty catch block
            }
        });
        this.watchThread.setDaemon(true);
        this.watchThread.start();
    }

    public static Path getResourcePath(Class<?> clazz) {
        return Paths.get("src/main/resources", clazz.getPackage().getName().replace(".", "/"));
    }

    public FileWatcher watchPath(Class<?> resourcePath) throws IOException {
        return this.watchPath(FileWatcher.getResourcePath(resourcePath));
    }

    public FileWatcher watchPath(Class<?> resourcePath, @NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.watchPath(FileWatcher.getResourcePath(resourcePath).resolve(path));
    }

    public FileWatcher watchFile(Class<?> resourcePath, @NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.watchFile(FileWatcher.getResourcePath(resourcePath).resolve(path));
    }

    public FileWatcher watchPath(@NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Path watchPath = path = path.toAbsolutePath();
        if (path.toFile().isFile() && (watchPath = path.getParent()) == null) {
            throw new IOException("Invalid path: " + path);
        }
        if (!watchPath.toFile().exists()) {
            throw new FileNotFoundException("Directory does not exist: " + watchPath);
        }
        WatchKey key = watchPath.register(this.watchService, eventKinds);
        this.watchKeys.put(key, path);
        return this;
    }

    public FileWatcher watchFile(@NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!(path = path.toAbsolutePath()).toFile().exists()) {
            log.warn("Watched file does not currently exist: {}", (Object)path);
        }
        if (path.getParent() == null) {
            throw new IOException("Invalid path: " + path);
        }
        WatchKey key = path.getParent().register(this.watchService, eventKinds);
        this.watchKeys.put(key, path);
        return this;
    }

    public FileWatcher unwatchPath(Path path) {
        path = path.toAbsolutePath();
        for (Map.Entry<WatchKey, Path> entry : this.watchKeys.entrySet()) {
            if (entry.getValue().toAbsolutePath().compareTo(path) != 0) continue;
            entry.getKey().cancel();
            this.watchKeys.remove(entry.getKey());
        }
        return this;
    }

    public FileWatcher addChangeHandler(Consumer<Path> changeHandler) {
        return this.addChangeHandler((Path path, WatchEvent<Path> event) -> changeHandler.accept((Path)path));
    }

    public FileWatcher addChangeHandler(BiConsumer<Path, WatchEvent<Path>> changeHandler) {
        this.changeHandlers.put(changeHandler.hashCode(), changeHandler);
        return this;
    }

    public FileWatcher removeChangeHandler(Consumer<Path> changeHandler) {
        this.changeHandlers.remove(changeHandler.hashCode());
        return this;
    }

    public FileWatcher removeChangeHandler(BiConsumer<Path, WatchEvent<Path>> changeHandler) {
        this.changeHandlers.remove(changeHandler.hashCode());
        return this;
    }

    @Override
    public void close() {
        this.watchKeys.clear();
        try {
            this.watchService.close();
            this.watchThread.join();
        }
        catch (IOException | InterruptedException ex) {
            log.warn("Failed to cleanly shut down file watcher", ex);
        }
        this.changeHandlers.clear();
    }
}

