/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene.lighting;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GroundObject;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Projectile;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.entityhider.EntityHiderConfig;
import net.runelite.client.plugins.entityhider.EntityHiderPlugin;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.scene.lighting.Alignment;
import net.runelite.client.plugins.hd.scene.lighting.Light;
import net.runelite.client.plugins.hd.scene.lighting.LightConfig;
import net.runelite.client.plugins.hd.scene.lighting.LightType;
import net.runelite.client.plugins.hd.scene.lighting.SceneLight;
import net.runelite.client.plugins.hd.utils.Env;
import net.runelite.client.plugins.hd.utils.FileWatcher;
import net.runelite.client.plugins.hd.utils.HDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LightManager {
    private static final Logger log = LoggerFactory.getLogger(LightManager.class);
    public static String ENV_LIGHTS_CONFIG = "RLHD_LIGHTS_PATH";
    @Inject
    private ConfigManager configManager;
    @Inject
    private HdPluginConfig config;
    @Inject
    private Client client;
    @Inject
    private HdPlugin hdPlugin;
    @Inject
    private EntityHiderPlugin entityHiderPlugin;
    @Inject
    private PluginManager pluginManager;
    private static final ArrayList<SceneLight> WORLD_LIGHTS = new ArrayList();
    private static final ListMultimap<Integer, Light> NPC_LIGHTS = ArrayListMultimap.create();
    private static final ListMultimap<Integer, Light> OBJECT_LIGHTS = ArrayListMultimap.create();
    private static final ListMultimap<Integer, Light> PROJECTILE_LIGHTS = ArrayListMultimap.create();
    private FileWatcher fileWatcher;
    ArrayList<SceneLight> sceneLights = new ArrayList();
    ArrayList<Projectile> sceneProjectiles = new ArrayList();
    long lastFrameTime = -1L;
    boolean hotswapScheduled = false;
    int sceneMinX = 0;
    int sceneMinY = 0;
    int sceneMaxX = 0;
    int sceneMaxY = 0;
    public int visibleLightsCount = 0;
    private EntityHiderConfig entityHiderConfig;
    static final float PI = (float)Math.PI;
    static final float TWO_PI = (float)Math.PI * 2;

    public void startUp() {
        this.entityHiderConfig = this.configManager.getConfig(EntityHiderConfig.class);
        Path lightsConfigPath = Env.getPath(ENV_LIGHTS_CONFIG);
        if (lightsConfigPath == null) {
            this.reloadLightConfiguration();
        } else {
            this.reloadLightConfiguration(lightsConfigPath.toFile());
            try {
                this.fileWatcher = new FileWatcher().watchFile(lightsConfigPath).addChangeHandler(path -> {
                    this.hotswapScheduled = true;
                });
            }
            catch (IOException ex) {
                log.info("Failed to initialize file watcher", ex);
            }
        }
    }

    public void shutDown() {
        this.reset();
        if (this.fileWatcher != null) {
            this.fileWatcher.close();
            this.fileWatcher = null;
        }
    }

    public void clearLightConfiguration() {
        WORLD_LIGHTS.clear();
        NPC_LIGHTS.clear();
        OBJECT_LIGHTS.clear();
        PROJECTILE_LIGHTS.clear();
    }

    public void reloadLightConfiguration() {
        this.clearLightConfiguration();
        LightConfig.load(WORLD_LIGHTS, NPC_LIGHTS, OBJECT_LIGHTS, PROJECTILE_LIGHTS);
    }

    public void reloadLightConfiguration(File jsonFile) {
        this.clearLightConfiguration();
        LightConfig.load(jsonFile, WORLD_LIGHTS, NPC_LIGHTS, OBJECT_LIGHTS, PROJECTILE_LIGHTS);
    }

    public void update() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.hotswapScheduled) {
            this.hotswapScheduled = false;
            Path lightsConfigPath = Env.getPath(ENV_LIGHTS_CONFIG);
            if (lightsConfigPath != null && lightsConfigPath.toFile().exists()) {
                this.reloadLightConfiguration(lightsConfigPath.toFile());
            } else {
                this.reloadLightConfiguration();
            }
            this.reset();
            this.loadSceneLights();
        }
        int camX = this.hdPlugin.camTarget[0];
        int camY = this.hdPlugin.camTarget[1];
        int camZ = this.hdPlugin.camTarget[2];
        Iterator<SceneLight> lightIterator = this.sceneLights.iterator();
        while (lightIterator.hasNext()) {
            Tile lightTile;
            Tile aboveTile;
            SceneLight light2 = lightIterator.next();
            long frameTime = System.currentTimeMillis() - this.lastFrameTime;
            light2.distance = Integer.MAX_VALUE;
            if (light2.projectile != null) {
                if (light2.projectile.getRemainingCycles() <= 0) {
                    lightIterator.remove();
                    this.sceneProjectiles.remove(light2.projectile);
                    continue;
                }
                light2.x = (int)light2.projectile.getX();
                light2.y = (int)light2.projectile.getY();
                light2.z = (int)light2.projectile.getZ();
                light2.visible = this.projectileLightVisible();
            }
            if (light2.npc != null) {
                if (light2.npc != this.client.getCachedNPCs()[light2.npc.getIndex()]) {
                    lightIterator.remove();
                    continue;
                }
                light2.x = light2.npc.getLocalLocation().getX();
                light2.y = light2.npc.getLocalLocation().getY();
                if (light2.alignment == Alignment.NORTH || light2.alignment == Alignment.NORTHEAST || light2.alignment == Alignment.NORTHWEST) {
                    light2.y += 64;
                }
                if (light2.alignment == Alignment.SOUTH || light2.alignment == Alignment.SOUTHEAST || light2.alignment == Alignment.SOUTHWEST) {
                    light2.y -= 64;
                }
                if (light2.alignment == Alignment.EAST || light2.alignment == Alignment.SOUTHEAST || light2.alignment == Alignment.NORTHEAST) {
                    light2.x += 64;
                }
                if (light2.alignment == Alignment.WEST || light2.alignment == Alignment.SOUTHWEST || light2.alignment == Alignment.NORTHWEST) {
                    light2.x -= 64;
                }
                int plane = light2.npc.getWorldLocation().getPlane();
                light2.plane = plane;
                int npcTileX = light2.npc.getLocalLocation().getSceneX();
                int npcTileY = light2.npc.getLocalLocation().getSceneY();
                if (npcTileX < 104 && npcTileY < 104 && npcTileX >= 0 && npcTileY >= 0) {
                    if (this.client.getScene().getTiles()[plane][npcTileX][npcTileY] != null && this.client.getScene().getTiles()[plane][npcTileX][npcTileY].getBridge() != null) {
                        ++plane;
                    }
                    float lerpX = (float)(light2.x % 128) / 128.0f;
                    float lerpY = (float)(light2.y % 128) / 128.0f;
                    int baseTileX = (int)Math.floor((float)light2.x / 128.0f);
                    int baseTileY = (int)Math.floor((float)light2.y / 128.0f);
                    float heightNorth = HDUtils.lerp(this.client.getTileHeights()[plane][baseTileX][baseTileY + 1], this.client.getTileHeights()[plane][baseTileX + 1][baseTileY + 1], lerpX);
                    float heightSouth = HDUtils.lerp(this.client.getTileHeights()[plane][baseTileX][baseTileY], this.client.getTileHeights()[plane][baseTileX + 1][baseTileY], lerpX);
                    float tileHeight = HDUtils.lerp(heightSouth, heightNorth, lerpY);
                    light2.z = (int)tileHeight - 1 - light2.height;
                    light2.visible = this.npcLightVisible(light2.npc);
                } else {
                    light2.visible = false;
                }
            }
            if (light2.type == LightType.FLICKER) {
                long repeatMs = 60000L;
                int offset = light2.randomOffset;
                float t = (float)((System.currentTimeMillis() + (long)offset) % repeatMs) / (float)repeatMs * ((float)Math.PI * 2);
                float flicker = (float)(Math.pow(Math.cos(11.0f * t), 2.0) + Math.pow(Math.cos(17.0f * t), 4.0) + Math.pow(Math.cos(23.0f * t), 6.0) + Math.pow(Math.cos(31.0f * t), 2.0) + Math.pow(Math.cos(71.0f * t), 2.0) / 3.0 + Math.pow(Math.cos(151.0f * t), 2.0) / 7.0) / 4.335f;
                float maxFlicker = 1.0f + light2.range / 100.0f;
                float minFlicker = 1.0f - light2.range / 100.0f;
                flicker = minFlicker + (maxFlicker - minFlicker) * flicker;
                light2.currentStrength = light2.strength * flicker;
                light2.currentSize = (int)((float)light2.radius * flicker * 1.5f);
            } else if (light2.type == LightType.PULSE) {
                float duration = light2.duration / 1000.0f;
                float range = light2.range / 100.0f;
                float fullRange = range * 2.0f;
                float change = (float)frameTime / 1000.0f / duration;
                light2.currentAnimation += change % 1.0f;
                light2.currentAnimation %= 1.0f;
                float output = light2.currentAnimation > 0.5f ? 1.0f - (light2.currentAnimation - 0.5f) * 2.0f : light2.currentAnimation * 2.0f;
                float multiplier = 1.0f - range + output * fullRange;
                light2.currentSize = (int)((float)light2.radius * multiplier);
                light2.currentStrength = light2.strength * multiplier;
            } else {
                light2.currentStrength = light2.strength;
                light2.currentSize = light2.radius;
                light2.currentColor = light2.color;
            }
            if (light2.fadeInDuration > 0) {
                light2.currentStrength *= Math.min((float)light2.currentFadeIn / (float)light2.fadeInDuration.intValue(), 1.0f);
                light2.currentFadeIn = (int)((long)light2.currentFadeIn + frameTime);
            }
            light2.distance = (int)Math.sqrt(Math.pow(camX - light2.x, 2.0) + Math.pow(camY - light2.y, 2.0) + Math.pow(camZ - light2.z, 2.0));
            int tileX = (int)Math.floor((float)light2.x / 128.0f);
            int tileY = (int)Math.floor((float)light2.y / 128.0f);
            int tileZ = light2.plane;
            light2.belowFloor = false;
            light2.aboveFloor = false;
            if (tileX >= 104 || tileY >= 104 || tileX < 0 || tileY < 0) continue;
            Tile tile = aboveTile = tileZ < 3 ? this.client.getScene().getTiles()[tileZ + 1][tileX][tileY] : null;
            if (aboveTile != null && (aboveTile.getSceneTilePaint() != null || aboveTile.getSceneTileModel() != null)) {
                light2.belowFloor = true;
            }
            if ((lightTile = this.client.getScene().getTiles()[tileZ][tileX][tileY]) == null || lightTile.getSceneTilePaint() == null && lightTile.getSceneTileModel() == null) continue;
            light2.aboveFloor = true;
        }
        this.sceneLights.sort(Comparator.comparingInt(light -> light.distance));
        this.lastFrameTime = System.currentTimeMillis();
    }

    public boolean npcLightVisible(NPC npc) {
        if (npc.getModel() == null) {
            return false;
        }
        if (this.pluginManager.isPluginEnabled(this.entityHiderPlugin)) {
            boolean isPet = npc.getComposition().isFollower();
            if (this.entityHiderConfig.hideNPCs() && !isPet) {
                return false;
            }
            if (this.entityHiderConfig.hidePets() && isPet) {
                return false;
            }
        }
        return this.hdPlugin.configNpcLights;
    }

    public boolean projectileLightVisible() {
        if (this.pluginManager.isPluginEnabled(this.entityHiderPlugin) && this.entityHiderConfig.hideProjectiles()) {
            return false;
        }
        return this.hdPlugin.configProjectileLights;
    }

    public void reset() {
        this.sceneLights = new ArrayList();
        this.sceneProjectiles = new ArrayList();
    }

    public void loadSceneLights() {
        this.sceneMinX = this.client.getBaseX();
        this.sceneMinY = this.client.getBaseY();
        if (this.client.isInInstancedRegion()) {
            LocalPoint localPoint = this.client.getLocalPlayer().getLocalLocation();
            WorldPoint worldPoint = WorldPoint.fromLocalInstance(this.client, localPoint);
            this.sceneMinX = worldPoint.getX() - localPoint.getSceneX();
            this.sceneMinY = worldPoint.getY() - localPoint.getSceneY();
        }
        this.sceneMaxX = this.sceneMinX + 104 - 2;
        this.sceneMaxY = this.sceneMinY + 104 - 2;
        for (SceneLight light : WORLD_LIGHTS) {
            if (light.worldX < this.sceneMinX || light.worldX > this.sceneMaxX || light.worldY < this.sceneMinY || light.worldY > this.sceneMaxY) continue;
            this.sceneLights.add(light);
            this.calculateScenePosition(light);
        }
        Tile[][][] tiles = this.client.getScene().getTiles();
        for (int i = 0; i < tiles.length; ++i) {
            for (int j = 0; j < tiles[i].length; ++j) {
                for (int k = 0; k < tiles[i][j].length; ++k) {
                    GroundObject groundObject;
                    WallObject wallObject;
                    Tile tile = tiles[i][j][k];
                    if (tile == null) continue;
                    DecorativeObject decorativeObject = tile.getDecorativeObject();
                    if (decorativeObject != null && decorativeObject.getRenderable() != null) {
                        this.addObjectLight(decorativeObject, tile.getRenderLevel());
                    }
                    if ((wallObject = tile.getWallObject()) != null && wallObject.getRenderable1() != null) {
                        int orientation = 0;
                        switch (wallObject.getOrientationA()) {
                            case 1: {
                                orientation = 512;
                                break;
                            }
                            case 2: {
                                orientation = 1024;
                                break;
                            }
                            case 4: {
                                orientation = 1536;
                                break;
                            }
                            case 8: {
                                orientation = 0;
                                break;
                            }
                            case 16: {
                                orientation = 768;
                                break;
                            }
                            case 32: {
                                orientation = 1280;
                                break;
                            }
                            case 64: {
                                orientation = 1792;
                                break;
                            }
                            case 128: {
                                orientation = 256;
                            }
                        }
                        this.addObjectLight(wallObject, tile.getRenderLevel(), 1, 1, orientation);
                    }
                    if ((groundObject = tile.getGroundObject()) != null && groundObject.getRenderable() != null) {
                        this.addObjectLight(groundObject, tile.getRenderLevel());
                    }
                    for (GameObject gameObject : tile.getGameObjects()) {
                        if (gameObject == null) continue;
                        this.addObjectLight(gameObject, tile.getRenderLevel(), gameObject.sizeX(), gameObject.sizeY(), gameObject.getOrientation().getAngle());
                    }
                }
            }
        }
        this.updateSceneNpcs();
    }

    public void updateSceneNpcs() {
        this.client.getNpcs().forEach(this::addNpcLights);
    }

    public void updateNpcChanged(NpcChanged npcChanged) {
        this.removeNpcLight(npcChanged);
        this.addNpcLights(npcChanged.getNpc());
    }

    public ArrayList<SceneLight> getVisibleLights(int maxDistance, int maxLights) {
        ArrayList<SceneLight> visibleLights = new ArrayList<SceneLight>();
        int lightsCount = 0;
        for (SceneLight light : this.sceneLights) {
            if (lightsCount >= maxLights || light.distance > maxDistance * 128) break;
            if (!light.visible || light.plane < this.client.getPlane() && light.belowFloor || light.plane > this.client.getPlane() && light.aboveFloor) continue;
            visibleLights.add(light);
            ++lightsCount;
        }
        this.visibleLightsCount = lightsCount;
        return visibleLights;
    }

    public void addProjectileLight(Projectile projectile) {
        for (Light l : PROJECTILE_LIGHTS.get((Object)projectile.getId())) {
            if (this.sceneProjectiles.contains(projectile)) continue;
            SceneLight light = new SceneLight(0, 0, projectile.getFloor(), 0, Alignment.CENTER, l.radius, l.strength, l.color, l.type, l.duration, l.range, 300);
            light.projectile = projectile;
            light.x = (int)projectile.getX();
            light.y = (int)projectile.getY();
            light.z = (int)projectile.getZ();
            this.sceneProjectiles.add(projectile);
            this.sceneLights.add(light);
        }
    }

    public void addNpcLights(NPC npc) {
        for (Light l : NPC_LIGHTS.get((Object)npc.getId())) {
            if (this.sceneLights.stream().anyMatch(x -> x.npc == npc)) continue;
            SceneLight light = new SceneLight(0, 0, -1, l.height, l.alignment, l.radius, l.strength, l.color, l.type, l.duration, l.range, 0);
            light.npc = npc;
            light.visible = false;
            this.sceneLights.add(light);
        }
    }

    public void removeNpcLight(NpcDespawned npcDespawned) {
        this.sceneLights.removeIf(light -> light.npc == npcDespawned.getNpc());
    }

    public void removeNpcLight(NpcChanged npcChanged) {
        this.sceneLights.removeIf(light -> light.npc == npcChanged.getNpc());
    }

    public void addObjectLight(TileObject tileObject, int plane) {
        this.addObjectLight(tileObject, plane, 1, 1, -1);
    }

    public void addObjectLight(TileObject tileObject, int plane, int sizeX, int sizeY, int orientation) {
        for (Light l : OBJECT_LIGHTS.get((Object)tileObject.getId())) {
            if (tileObject.getPlane() <= -1 || this.sceneLights.stream().anyMatch(light -> light.object != null && this.tileObjectHash(light.object) == this.tileObjectHash(tileObject))) continue;
            WorldPoint worldLocation = tileObject.getWorldLocation();
            SceneLight light2 = new SceneLight(worldLocation.getX(), worldLocation.getY(), worldLocation.getPlane(), l.height, l.alignment, l.radius, l.strength, l.color, l.type, l.duration, l.range, 0);
            LocalPoint localLocation = tileObject.getLocalLocation();
            light2.x = localLocation.getX();
            light2.y = localLocation.getY();
            int lightX = tileObject.getX();
            int lightY = tileObject.getY();
            int localSizeX = sizeX * 128;
            int localSizeY = sizeY * 128;
            if (orientation != -1 && light2.alignment != Alignment.CENTER) {
                float radius = (float)localSizeX / 2.0f;
                if (!light2.alignment.radial) {
                    radius = (float)Math.sqrt(localSizeX * localSizeX + localSizeX * localSizeX) / 2.0f;
                }
                if (!light2.alignment.relative) {
                    orientation = 0;
                }
                orientation += light2.alignment.orientation;
                float sine = (float)Perspective.SINE[orientation %= 2048] / 65536.0f;
                float cosine = (float)Perspective.COSINE[orientation] / 65536.0f;
                int offsetX = (int)(radius * sine);
                int offsetY = (int)(radius * (cosine /= (float)localSizeX / (float)localSizeY));
                lightX += offsetX;
                lightY += offsetY;
            }
            float tileX = (float)lightX / 128.0f;
            float tileY = (float)lightY / 128.0f;
            float lerpX = (float)(lightX % 128) / 128.0f;
            float lerpY = (float)(lightY % 128) / 128.0f;
            int tileMinX = (int)Math.floor(tileX);
            int tileMinY = (int)Math.floor(tileY);
            int tileMaxX = tileMinX + 1;
            int tileMaxY = tileMinY + 1;
            tileMinX = Ints.constrainToRange(tileMinX, 0, 103);
            tileMinY = Ints.constrainToRange(tileMinY, 0, 103);
            tileMaxX = Ints.constrainToRange(tileMaxX, 0, 103);
            tileMaxY = Ints.constrainToRange(tileMaxY, 0, 103);
            float heightNorth = HDUtils.lerp(this.client.getTileHeights()[plane][tileMinX][tileMaxY], this.client.getTileHeights()[plane][tileMaxX][tileMaxY], lerpX);
            float heightSouth = HDUtils.lerp(this.client.getTileHeights()[plane][tileMinX][tileMinY], this.client.getTileHeights()[plane][tileMaxX][tileMinY], lerpX);
            float tileHeight = HDUtils.lerp(heightSouth, heightNorth, lerpY);
            light2.x = lightX;
            light2.y = lightY;
            light2.z = (int)tileHeight - light2.height - 1;
            light2.object = tileObject;
            this.sceneLights.add(light2);
        }
    }

    public void removeObjectLight(TileObject tileObject) {
        for (Light l : OBJECT_LIGHTS.get((Object)tileObject.getId())) {
            LocalPoint localLocation = tileObject.getLocalLocation();
            int plane = tileObject.getWorldLocation().getPlane();
            this.sceneLights.removeIf(light -> light.x == localLocation.getX() && light.y == localLocation.getY() && light.plane == plane);
        }
    }

    int tileObjectHash(TileObject tileObject) {
        return tileObject.getWorldLocation().getX() * tileObject.getWorldLocation().getY() * (tileObject.getPlane() + 1) + tileObject.getId();
    }

    void calculateScenePosition(SceneLight light) {
        light.x = (light.worldX - this.sceneMinX) * 128 + 64;
        light.y = (light.worldY - this.sceneMinY) * 128 + 64;
        light.z = this.client.getTileHeights()[light.plane][light.worldX - this.sceneMinX][light.worldY - this.sceneMinY] - light.height - 1;
        if (light.alignment == Alignment.NORTH || light.alignment == Alignment.NORTHEAST || light.alignment == Alignment.NORTHWEST) {
            light.y += 64;
        }
        if (light.alignment == Alignment.EAST || light.alignment == Alignment.NORTHEAST || light.alignment == Alignment.SOUTHEAST) {
            light.x += 64;
        }
        if (light.alignment == Alignment.SOUTH || light.alignment == Alignment.SOUTHEAST || light.alignment == Alignment.SOUTHWEST) {
            light.y -= 64;
        }
        if (light.alignment == Alignment.WEST || light.alignment == Alignment.NORTHWEST || light.alignment == Alignment.SOUTHWEST) {
            light.x -= 64;
        }
    }

    public ArrayList<SceneLight> getSceneLights() {
        return this.sceneLights;
    }

    public ArrayList<Projectile> getSceneProjectiles() {
        return this.sceneProjectiles;
    }
}

