/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import javax.inject.Singleton;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.client.plugins.hd.HdPlugin;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TextureManager {
    private static final Logger log = LoggerFactory.getLogger(TextureManager.class);
    private static final float PERC_64 = 0.015625f;
    private static final float PERC_128 = 0.0078125f;
    private static final int TEXTURE_SIZE = 128;

    public int initTextureArray(TextureProvider textureProvider) {
        if (!this.allTexturesLoaded(textureProvider)) {
            return -1;
        }
        Texture[] textures = textureProvider.getTextures();
        int textureArrayId = GL43C.glGenTextures();
        GL43C.glBindTexture(35866, textureArrayId);
        if (GL.getCapabilities().glTexStorage3D != 0L) {
            GL43C.glTexStorage3D(35866, 8, 32856, 128, 128, textures.length);
        } else {
            int size = 128;
            for (int i = 0; i < 8; ++i) {
                GL43C.glTexImage3D(35866, i, 32856, size, size, textures.length, 0, 6408, 5121, 0L);
                size /= 2;
            }
        }
        GL43C.glTexParameteri(35866, 10241, 9728);
        GL43C.glTexParameteri(35866, 10240, 9728);
        GL43C.glTexParameteri(35866, 10242, 33071);
        double save = textureProvider.getBrightness();
        textureProvider.setBrightness(1.0);
        this.updateTextures(textureProvider, textureArrayId);
        textureProvider.setBrightness(save);
        GL43C.glActiveTexture(33985);
        GL43C.glBindTexture(35866, textureArrayId);
        GL43C.glGenerateMipmap(35866);
        GL43C.glActiveTexture(33984);
        return textureArrayId;
    }

    public int initTextureHDArray(TextureProvider textureProvider) {
        if (!this.allTexturesLoaded(textureProvider)) {
            return -1;
        }
        Texture[] textures = textureProvider.getTextures();
        int textureCount = textureProvider.getTextures().length;
        int textureArrayId = GL43C.glGenTextures();
        GL43C.glBindTexture(35866, textureArrayId);
        if (GL.getCapabilities().glTexStorage3D != 0L) {
            GL43C.glTexStorage3D(35866, 8, 35907, 128, 128, textureCount);
        } else {
            int size = 128;
            for (int i = 0; i < 8; ++i) {
                GL43C.glTexImage3D(35866, i, 35907, size, size, textureCount, 0, 6408, 5121, 0L);
                size /= 2;
            }
        }
        GL43C.glTexParameteri(35866, 10242, 10497);
        GL43C.glTexParameteri(35866, 10243, 10497);
        double save = textureProvider.getBrightness();
        textureProvider.setBrightness(1.0);
        int cnt = 0;
        for (int textureId = 0; textureId < textureCount; ++textureId) {
            if (!this.loadHDTexture(textureId, textureProvider, textures)) continue;
            ++cnt;
        }
        textureProvider.setBrightness(save);
        log.debug("Uploaded HD textures {}", (Object)cnt);
        GL43C.glActiveTexture(33986);
        GL43C.glBindTexture(35866, textureArrayId);
        GL43C.glGenerateMipmap(35866);
        GL43C.glActiveTexture(33984);
        return textureArrayId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean loadHDTexture(int textureId, TextureProvider textureProvider, Texture[] textures) {
        block20: {
            int width = 0;
            int height = 0;
            try (InputStream in = HdPlugin.class.getResourceAsStream("textures/" + textureId + ".png");){
                if (in == null) break block20;
                Class<ImageIO> clazz = ImageIO.class;
                synchronized (ImageIO.class) {
                    int i;
                    BufferedImage image = ImageIO.read(in);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    width = image.getWidth();
                    height = image.getHeight();
                    boolean hasAlphaChannel = image.getAlphaRaster() != null;
                    int bytesPerPixel = hasAlphaChannel ? 4 : 3;
                    byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    assert (width * height * bytesPerPixel == pixels.length);
                    if (!$assertionsDisabled) {
                        if (width != 128) throw new AssertionError();
                        if (height != 128) {
                            throw new AssertionError();
                        }
                    }
                    ByteBuffer pixelData = ByteBuffer.allocateDirect(width * height * bytesPerPixel).order(ByteOrder.nativeOrder());
                    if (hasAlphaChannel) {
                        for (i = 0; i < pixels.length; i += 4) {
                            byte a = pixels[i];
                            byte r = pixels[i + 1];
                            byte g2 = pixels[i + 2];
                            byte b = pixels[i + 3];
                            pixelData.put(b).put(g2).put(r).put(a);
                        }
                    } else {
                        assert (width * 3 % 4 == 0) : "OpenGL expects each line of the image to start at a memory address divisible by 4";
                        for (i = 0; i < pixels.length; i += 3) {
                            byte r = pixels[i];
                            byte g3 = pixels[i + 1];
                            byte b = pixels[i + 2];
                            pixelData.put(b).put(g3).put(r);
                        }
                    }
                    pixelData.flip();
                    int rgbMode = hasAlphaChannel ? 6408 : 6407;
                    GL43C.glTexSubImage3D(35866, 0, 0, 0, textureId, width, height, 1, rgbMode, 5121, pixelData);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (textureId >= textures.length) return false;
        Texture texture = textures[textureId];
        if (texture == null) return false;
        int[] srcPixels = textureProvider.load(textureId);
        if (srcPixels == null) {
            log.warn("hd No pixels for texture {}!", (Object)textureId);
            return false;
        }
        if (srcPixels.length != 16384) {
            log.warn("HD Texture size for {} is {}!", (Object)textureId, (Object)srcPixels.length);
        }
        byte[] pixels = TextureManager.convertPixels(srcPixels, texture.getSize(), texture.getSize(), texture.getSize(), texture.getSize());
        ByteBuffer pixelBuffer = ByteBuffer.allocateDirect(pixels.length);
        pixelBuffer.put(pixels);
        pixelBuffer.flip();
        GL43C.glTexSubImage3D(35866, 0, 0, 0, textureId, texture.getSize(), texture.getSize(), 1, 6408, 5121, pixelBuffer);
        return true;
    }

    public void setAnisotropicFilteringLevel(int textureArrayId, int level, boolean trilinearFiltering) {
        GL43C.glBindTexture(35866, textureArrayId);
        if (level == 0) {
            GL43C.glTexParameteri(35866, 10241, 9728);
        } else if (trilinearFiltering) {
            GL43C.glTexParameteri(35866, 10241, 9987);
        } else {
            GL43C.glTexParameteri(35866, 10241, 9986);
        }
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxSamples = GL43C.glGetFloat(34047);
            float anisoLevel = Math.max(1.0f, Math.min(maxSamples, (float)level));
            GL43C.glTexParameterf(35866, 34046, anisoLevel);
        }
    }

    public void freeTextureArray(int textureArrayId) {
        GL43C.glDeleteTextures(textureArrayId);
    }

    private boolean allTexturesLoaded(TextureProvider textureProvider) {
        Texture[] textures = textureProvider.getTextures();
        if (textures == null || textures.length == 0) {
            return false;
        }
        for (int textureId = 0; textureId < textures.length; ++textureId) {
            int[] pixels;
            Texture texture = textures[textureId];
            if (texture == null || (pixels = textureProvider.load(textureId)) != null) continue;
            return false;
        }
        return true;
    }

    private void updateTextures(TextureProvider textureProvider, int textureArrayId) {
        Texture[] textures = textureProvider.getTextures();
        GL43C.glBindTexture(35866, textureArrayId);
        int cnt = 0;
        for (int textureId = 0; textureId < textures.length; ++textureId) {
            Texture texture = textures[textureId];
            if (texture == null) continue;
            int[] srcPixels = textureProvider.load(textureId);
            if (srcPixels == null) {
                log.warn("Update No pixels for texture {}!", (Object)textureId);
                continue;
            }
            ++cnt;
            if (srcPixels.length != 16384) {
                log.warn("Texture size for {} is {}!", (Object)textureId, (Object)srcPixels.length);
                continue;
            }
            byte[] pixels = TextureManager.convertPixels(srcPixels, 128, 128, 128, 128);
            ByteBuffer pixelBuffer = ByteBuffer.allocateDirect(pixels.length);
            pixelBuffer.put(pixels);
            pixelBuffer.flip();
            GL43C.glTexSubImage3D(35866, 0, 0, 0, textureId, 128, 128, 1, 6408, 5121, pixelBuffer);
        }
        log.debug("Uploaded textures {}", (Object)cnt);
    }

    private static byte[] convertPixels(int[] srcPixels, int width, int height, int textureWidth, int textureHeight) {
        byte[] pixels = new byte[textureWidth * textureHeight * 4];
        int pixelIdx = 0;
        int srcPixelIdx = 0;
        int offset = (textureWidth - width) * 4;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb;
                if ((rgb = srcPixels[srcPixelIdx++]) != 0) {
                    pixels[pixelIdx++] = (byte)(rgb >> 16);
                    pixels[pixelIdx++] = (byte)(rgb >> 8);
                    pixels[pixelIdx++] = (byte)rgb;
                    pixels[pixelIdx++] = -1;
                    continue;
                }
                pixelIdx += 4;
            }
            pixelIdx += offset;
        }
        return pixels;
    }

    public void animate(Texture texture, int diff) {
        int[] pixels = texture.getPixels();
        if (pixels == null) {
            return;
        }
        int animationSpeed = texture.getAnimationSpeed();
        float uvdiff = pixels.length == 4096 ? 0.015625f : 0.0078125f;
        float u = texture.getU();
        float v = texture.getV();
        int offset = animationSpeed * diff;
        float d = (float)offset * uvdiff;
        switch (texture.getAnimationDirection()) {
            case 1: {
                v -= d;
                if (!(v < 0.0f)) break;
                v += 1.0f;
                break;
            }
            case 3: {
                v += d;
                if (!(v > 1.0f)) break;
                v -= 1.0f;
                break;
            }
            case 2: {
                u -= d;
                if (!(u < 0.0f)) break;
                u += 1.0f;
                break;
            }
            case 4: {
                u += d;
                if (!(u > 1.0f)) break;
                u -= 1.0f;
                break;
            }
            default: {
                return;
            }
        }
        texture.setU(u);
        texture.setV(v);
    }
}

