/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.data.WaterType;
import net.runelite.client.plugins.hd.data.materials.GroundMaterial;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.data.materials.Overlay;
import net.runelite.client.plugins.hd.data.materials.Underlay;
import net.runelite.client.plugins.hd.model.objects.ObjectProperties;
import net.runelite.client.plugins.hd.model.objects.ObjectType;
import net.runelite.client.plugins.hd.model.objects.TzHaarRecolorType;
import net.runelite.client.plugins.hd.utils.HDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProceduralGenerator {
    private static final Logger log = LoggerFactory.getLogger(ProceduralGenerator.class);
    @Inject
    private Client client;
    @Inject
    private HdPlugin hdPlugin;
    private final int VERTICES_PER_FACE = 3;
    Map<Integer, Integer> vertexTerrainColor;
    Map<Integer, Material> vertexTerrainTexture;
    Map<Integer, float[]> vertexTerrainNormals;
    HashMap<Integer, Boolean> highPriorityColor;
    boolean[][][] tileIsWater;
    Map<Integer, Boolean> vertexIsWater;
    Map<Integer, Boolean> vertexIsLand;
    Map<Integer, Boolean> vertexIsOverlay;
    Map<Integer, Boolean> vertexIsUnderlay;
    boolean[][][] skipTile;
    Map<Integer, Integer> vertexUnderwaterDepth;
    int[][][] underwaterDepthLevels;
    int[] depthLevelSlope = new int[]{150, 300, 470, 610, 700, 750, 820, 920, 1080, 1300, 1350, 1380};
    boolean[][] tileOverlayTris = new boolean[][]{{true, true, true, true}, {false, true}, {false, false, true}, {false, false, true}, {false, true, true}, {false, true, true}, {false, false, true, true}, {false, false, false, true}, {false, true, true, true}, {false, false, false, true, true, true}, {true, true, true, false, false, false}, {true, true, false, false, false, false}};
    int[][] tzHaarRecolored = new int[4][3];
    final int[] gradientBaseColor = new int[]{3, 4, 26};
    final int[] gradientDarkColor = new int[]{3, 4, 10};
    final int gradientBottom = 200;
    final int gradientTop = -200;

    public void generateTerrainData(Scene scene) {
        this.vertexTerrainColor = new HashMap<Integer, Integer>();
        this.highPriorityColor = new HashMap();
        this.vertexTerrainTexture = new HashMap<Integer, Material>();
        this.vertexIsUnderlay = new HashMap<Integer, Boolean>();
        this.vertexIsOverlay = new HashMap<Integer, Boolean>();
        Tile[][][] tiles = scene.getTiles();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    if (tiles[z][x][y] == null) continue;
                    if (tiles[z][x][y].getBridge() != null) {
                        this.generateDataForTile(tiles[z][x][y].getBridge());
                    }
                    this.generateDataForTile(tiles[z][x][y]);
                }
            }
        }
    }

    void generateDataForTile(Tile tile) {
        int faceCount;
        if (tile.getSceneTilePaint() != null) {
            faceCount = 2;
        } else if (tile.getSceneTileModel() != null) {
            faceCount = tile.getSceneTileModel().getFaceX().length;
        } else {
            return;
        }
        int[] vertexHashes = new int[faceCount * 3];
        int[] vertexColors = new int[faceCount * 3];
        int[] vertexOverlays = new int[faceCount * 3];
        int[] vertexUnderlays = new int[faceCount * 3];
        boolean[] vertexDefaultColor = new boolean[faceCount * 3];
        int z = tile.getRenderLevel();
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int worldX = tile.getWorldLocation().getX();
        int worldY = tile.getWorldLocation().getY();
        if (tile.getSceneTilePaint() != null) {
            if (this.tileWaterType(tile, tile.getSceneTilePaint()) != WaterType.NONE) {
                return;
            }
            int swColor = tile.getSceneTilePaint().getSwColor();
            int seColor = tile.getSceneTilePaint().getSeColor();
            int nwColor = tile.getSceneTilePaint().getNwColor();
            int neColor = tile.getSceneTilePaint().getNeColor();
            vertexHashes = this.tileVertexKeys(tile);
            if (x >= 102 && y >= 102) {
                neColor = swColor;
                nwColor = swColor;
                seColor = swColor;
            } else if (y >= 102) {
                nwColor = swColor;
                neColor = seColor;
            } else if (x >= 102) {
                neColor = nwColor;
                seColor = swColor;
            }
            vertexColors[0] = swColor;
            vertexColors[1] = seColor;
            vertexColors[2] = nwColor;
            vertexColors[3] = neColor;
            vertexOverlays[2] = vertexOverlays[3] = this.client.getScene().getOverlayIds()[z][x][y];
            vertexOverlays[1] = vertexOverlays[3];
            vertexOverlays[0] = vertexOverlays[3];
            vertexUnderlays[2] = vertexUnderlays[3] = this.client.getScene().getUnderlayIds()[z][x][y];
            vertexUnderlays[1] = vertexUnderlays[3];
            vertexUnderlays[0] = vertexUnderlays[3];
            if (this.useDefaultColor(tile)) {
                vertexDefaultColor[3] = true;
                vertexDefaultColor[2] = true;
                vertexDefaultColor[1] = true;
                vertexDefaultColor[0] = true;
            }
        } else if (tile.getSceneTileModel() != null) {
            SceneTileModel sceneTileModel = tile.getSceneTileModel();
            int[] faceColorsA = sceneTileModel.getTriangleColorA();
            int[] faceColorsB = sceneTileModel.getTriangleColorB();
            int[] faceColorsC = sceneTileModel.getTriangleColorC();
            for (int face = 0; face < faceCount; ++face) {
                int[] faceColors = new int[]{faceColorsA[face], faceColorsB[face], faceColorsC[face]};
                int[] vertexKeys = this.faceVertexKeys(tile, face);
                for (int vertex = 0; vertex < 3; ++vertex) {
                    int color;
                    if (this.faceWaterType(tile, face, sceneTileModel) != WaterType.NONE) continue;
                    vertexHashes[face * 3 + vertex] = vertexKeys[vertex];
                    vertexColors[face * 3 + vertex] = color = faceColors[vertex];
                    if (this.isOverlayFace(tile, face)) {
                        vertexOverlays[face * 3 + vertex] = this.client.getScene().getOverlayIds()[z][x][y];
                    }
                    vertexUnderlays[face * 3 + vertex] = this.client.getScene().getUnderlayIds()[z][x][y];
                    if (!this.isOverlayFace(tile, face) || !this.useDefaultColor(tile)) continue;
                    vertexDefaultColor[face * 3 + vertex] = true;
                }
            }
        }
        for (int vertex = 0; vertex < vertexHashes.length; ++vertex) {
            GroundMaterial groundMaterial;
            if (vertexHashes[vertex] == 0 || vertexColors[vertex] < 0 || vertexColors[vertex] > 65535) continue;
            boolean lowPriorityColor = false;
            if (vertexColors[vertex] <= 2) {
                lowPriorityColor = true;
            }
            int[] colorHSL = HDUtils.colorIntToHSL(vertexColors[vertex]);
            float lightenMultiplier = 1.5f;
            int lightenBase = 15;
            int lightenAdd = 3;
            float darkenMultiplier = 0.5f;
            int darkenBase = 0;
            int darkenAdd = 0;
            float[] vNormals = this.vertexTerrainNormals.getOrDefault(vertexHashes[vertex], new float[]{0.0f, 0.0f, 0.0f});
            float dot = HDUtils.dotNormal3Lights(vNormals, false);
            int lighten = (int)((float)Math.max(colorHSL[2] - lightenAdd, 0) * lightenMultiplier) + lightenBase;
            colorHSL[2] = (int)HDUtils.lerp(colorHSL[2], lighten, Math.max(dot, 0.0f));
            int darken = (int)((float)Math.max(colorHSL[2] - darkenAdd, 0) * darkenMultiplier) + darkenBase;
            colorHSL[2] = (int)HDUtils.lerp(colorHSL[2], darken, Math.abs(Math.min(dot, 0.0f)));
            colorHSL[2] = (int)((float)colorHSL[2] * 1.25f);
            boolean isOverlay = false;
            Material material = Material.DIRT_1;
            if (vertexOverlays[vertex] != 0) {
                Overlay overlay = Overlay.getOverlay(vertexOverlays[vertex], tile, this.client);
                overlay = this.getSeasonalOverlay(overlay);
                groundMaterial = overlay.getGroundMaterial();
                material = groundMaterial.getRandomMaterial(z, worldX, worldY);
                isOverlay = !overlay.isBlendedAsUnderlay();
                colorHSL = this.recolorOverlay(overlay, colorHSL);
            } else if (vertexUnderlays[vertex] != 0) {
                Underlay underlay = Underlay.getUnderlay(vertexUnderlays[vertex], tile, this.client);
                underlay = this.getSeasonalUnderlay(underlay);
                groundMaterial = underlay.getGroundMaterial();
                material = groundMaterial.getRandomMaterial(z, worldX, worldY);
                isOverlay = underlay.isBlendedAsOverlay();
                colorHSL = this.recolorUnderlay(underlay, colorHSL);
            }
            int maxBrightness = 55;
            colorHSL[2] = Ints.constrainToRange(colorHSL[2], 0, 55);
            vertexColors[vertex] = HDUtils.colorHSLToInt(colorHSL);
            if (isOverlay) {
                this.vertexIsOverlay.put(vertexHashes[vertex], true);
            } else {
                this.vertexIsUnderlay.put(vertexHashes[vertex], true);
            }
            if (lowPriorityColor && this.highPriorityColor.containsKey(vertexHashes[vertex]) || vertexDefaultColor[vertex]) continue;
            if (vertexOverlays[vertex] != 0 || !this.vertexTerrainColor.containsKey(vertexHashes[vertex]) || !this.highPriorityColor.containsKey(vertexHashes[vertex])) {
                this.vertexTerrainColor.put(vertexHashes[vertex], vertexColors[vertex]);
            }
            if (vertexOverlays[vertex] != 0 || !this.vertexTerrainTexture.containsKey(vertexHashes[vertex]) || !this.highPriorityColor.containsKey(vertexHashes[vertex])) {
                this.vertexTerrainTexture.put(vertexHashes[vertex], material);
            }
            if (lowPriorityColor) continue;
            this.highPriorityColor.put(vertexHashes[vertex], true);
        }
    }

    public void generateUnderwaterTerrain(Scene scene) {
        int vY;
        int vX;
        int vertex;
        int y;
        int x;
        int z;
        this.tileIsWater = new boolean[4][104][104];
        this.vertexIsWater = new HashMap<Integer, Boolean>();
        this.vertexIsLand = new HashMap<Integer, Boolean>();
        this.skipTile = new boolean[4][104][104];
        this.vertexUnderwaterDepth = new HashMap<Integer, Integer>();
        this.underwaterDepthLevels = new int[4][105][105];
        int[][][] underwaterDepths = new int[4][105][105];
        Tile[][][] tiles = scene.getTiles();
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 104; ++x) {
                Arrays.fill(this.underwaterDepthLevels[z][x], 1);
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 104; ++x) {
                for (y = 0; y < 104; ++y) {
                    if (tiles[z][x][y] == null) {
                        this.underwaterDepthLevels[z][x][y] = 0;
                        this.underwaterDepthLevels[z][x + 1][y] = 0;
                        this.underwaterDepthLevels[z][x][y + 1] = 0;
                        this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                        continue;
                    }
                    Tile tile = tiles[z][x][y];
                    if (tile.getBridge() != null) {
                        tile = tile.getBridge();
                    }
                    if (tile.getSceneTilePaint() != null) {
                        int checkZ;
                        int n;
                        int[] vertexKeys = this.tileVertexKeys(tile);
                        if (this.tileWaterType(tile, tile.getSceneTilePaint()) == WaterType.NONE) {
                            int[] nArray = vertexKeys;
                            int n2 = nArray.length;
                            for (n = 0; n < n2; ++n) {
                                int vertexKey = nArray[n];
                                if (tile.getSceneTilePaint().getNeColor() == 12345678) continue;
                                this.vertexIsLand.put(vertexKey, true);
                            }
                            this.underwaterDepthLevels[z][x][y] = 0;
                            this.underwaterDepthLevels[z][x + 1][y] = 0;
                            this.underwaterDepthLevels[z][x][y + 1] = 0;
                            this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                            continue;
                        }
                        if (z > 0) {
                            boolean continueLoop = false;
                            for (checkZ = 0; checkZ < z; ++checkZ) {
                                if (!this.tileIsWater[checkZ][x][y]) continue;
                                this.underwaterDepthLevels[z][x][y] = 0;
                                this.underwaterDepthLevels[z][x + 1][y] = 0;
                                this.underwaterDepthLevels[z][x][y + 1] = 0;
                                this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                                this.skipTile[z][x][y] = true;
                                continueLoop = true;
                                break;
                            }
                            if (continueLoop) continue;
                        }
                        this.tileIsWater[z][x][y] = true;
                        int[] continueLoop = vertexKeys;
                        checkZ = continueLoop.length;
                        for (n = 0; n < checkZ; ++n) {
                            int vertexKey = continueLoop[n];
                            this.vertexIsWater.put(vertexKey, true);
                        }
                        continue;
                    }
                    if (tile.getSceneTileModel() != null) {
                        SceneTileModel sceneTileModel = tile.getSceneTileModel();
                        int faceCount = sceneTileModel.getFaceX().length;
                        if (z > 0) {
                            boolean tileIncludesWater = false;
                            for (int face = 0; face < faceCount; ++face) {
                                if (this.faceWaterType(tile, face, sceneTileModel) == WaterType.NONE) continue;
                                tileIncludesWater = true;
                                break;
                            }
                            if (tileIncludesWater) {
                                boolean continueLoop = false;
                                for (int checkZ = 0; checkZ < z; ++checkZ) {
                                    if (!this.tileIsWater[checkZ][x][y]) continue;
                                    this.underwaterDepthLevels[z][x][y] = 0;
                                    this.underwaterDepthLevels[z][x + 1][y] = 0;
                                    this.underwaterDepthLevels[z][x][y + 1] = 0;
                                    this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                                    this.skipTile[z][x][y] = true;
                                    continueLoop = true;
                                    break;
                                }
                                if (continueLoop) continue;
                            }
                        }
                        for (int face = 0; face < faceCount; ++face) {
                            int[][] vertices = this.faceVertices(tile, face);
                            int[] vertexKeys = this.faceVertexKeys(tile, face);
                            if (this.faceWaterType(tile, face, sceneTileModel) == WaterType.NONE) {
                                for (vertex = 0; vertex < 3; ++vertex) {
                                    if (sceneTileModel.getTriangleColorA()[face] != 12345678) {
                                        this.vertexIsLand.put(vertexKeys[vertex], true);
                                    }
                                    if (vertices[vertex][0] % 128 != 0 || vertices[vertex][1] % 128 != 0) continue;
                                    vX = vertices[vertex][0] / 128;
                                    vY = vertices[vertex][1] / 128;
                                    this.underwaterDepthLevels[z][vX][vY] = 0;
                                }
                                continue;
                            }
                            this.tileIsWater[z][x][y] = true;
                            for (vertex = 0; vertex < 3; ++vertex) {
                                this.vertexIsWater.put(vertexKeys[vertex], true);
                            }
                        }
                        continue;
                    }
                    this.underwaterDepthLevels[z][x][y] = 0;
                    this.underwaterDepthLevels[z][x + 1][y] = 0;
                    this.underwaterDepthLevels[z][x][y + 1] = 0;
                    this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                }
            }
        }
        for (int level = 0; level < this.depthLevelSlope.length - 1; ++level) {
            for (int z2 = 0; z2 < 4; ++z2) {
                for (int x2 = 0; x2 < this.underwaterDepthLevels[z2].length; ++x2) {
                    for (int y2 = 0; y2 < this.underwaterDepthLevels[z2][x2].length; ++y2) {
                        if (this.underwaterDepthLevels[z2][x2][y2] == 0) continue;
                        if (x2 == 0 || y2 == 0 || x2 == 104 || y2 == 104) {
                            this.underwaterDepthLevels[z2][x2][y2] = 0;
                            continue;
                        }
                        int tileHeight = this.underwaterDepthLevels[z2][x2][y2];
                        if (this.underwaterDepthLevels[z2][x2 - 1][y2] < tileHeight || x2 < this.underwaterDepthLevels[z2].length - 1 && this.underwaterDepthLevels[z2][x2 + 1][y2] < tileHeight || this.underwaterDepthLevels[z2][x2][y2 - 1] < tileHeight || y2 < this.underwaterDepthLevels[z2].length - 1 && this.underwaterDepthLevels[z2][x2][y2 + 1] < tileHeight) continue;
                        int[] nArray = this.underwaterDepthLevels[z2][x2];
                        int n = y2;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < this.underwaterDepthLevels[z].length; ++x) {
                for (y = 0; y < this.underwaterDepthLevels[z][x].length; ++y) {
                    int heightOffset;
                    if (this.underwaterDepthLevels[z][x][y] == 0) continue;
                    int maxRange = this.depthLevelSlope[this.underwaterDepthLevels[z][x][y] - 1];
                    int minRange = (int)((float)this.depthLevelSlope[this.underwaterDepthLevels[z][x][y] - 1] * 0.1f);
                    float noiseOffset = 0.5f;
                    float minOffset = 0.25f;
                    float maxOffset = 0.75f;
                    noiseOffset = HDUtils.lerp(minOffset, maxOffset, noiseOffset);
                    underwaterDepths[z][x][y] = heightOffset = (int)HDUtils.lerp(minRange, maxRange, noiseOffset);
                }
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 104; ++x) {
                for (y = 0; y < 104; ++y) {
                    if (!this.tileIsWater[z][x][y]) continue;
                    Tile tile = tiles[z][x][y];
                    if (tile.getBridge() != null) {
                        tile = tile.getBridge();
                    }
                    if (tile.getSceneTilePaint() != null) {
                        int[] vertexKeys = this.tileVertexKeys(tile);
                        int swVertexKey = vertexKeys[0];
                        int seVertexKey = vertexKeys[1];
                        int nwVertexKey = vertexKeys[2];
                        int neVertexKey = vertexKeys[3];
                        this.vertexUnderwaterDepth.put(swVertexKey, underwaterDepths[z][x][y]);
                        this.vertexUnderwaterDepth.put(seVertexKey, underwaterDepths[z][x + 1][y]);
                        this.vertexUnderwaterDepth.put(nwVertexKey, underwaterDepths[z][x][y + 1]);
                        this.vertexUnderwaterDepth.put(neVertexKey, underwaterDepths[z][x + 1][y + 1]);
                        continue;
                    }
                    if (tile.getSceneTileModel() == null) continue;
                    SceneTileModel sceneTileModel = tile.getSceneTileModel();
                    int faceCount = sceneTileModel.getFaceX().length;
                    for (int face = 0; face < faceCount; ++face) {
                        int[][] vertices = this.faceVertices(tile, face);
                        int[] vertexKeys = this.faceVertexKeys(tile, face);
                        for (vertex = 0; vertex < 3; ++vertex) {
                            if (vertices[vertex][0] % 128 == 0 && vertices[vertex][1] % 128 == 0) {
                                vX = vertices[vertex][0] / 128;
                                vY = vertices[vertex][1] / 128;
                                this.vertexUnderwaterDepth.put(vertexKeys[vertex], underwaterDepths[z][vX][vY]);
                                continue;
                            }
                            int localVertexX = vertices[vertex][0] - x * 128;
                            int localVertexY = vertices[vertex][1] - y * 128;
                            float lerpX = (float)localVertexX / 128.0f;
                            float lerpY = (float)localVertexY / 128.0f;
                            float northHeightOffset = HDUtils.lerp(underwaterDepths[z][x][y + 1], underwaterDepths[z][x + 1][y + 1], lerpX);
                            float southHeightOffset = HDUtils.lerp(underwaterDepths[z][x][y], underwaterDepths[z][x + 1][y], lerpX);
                            int heightOffset = (int)HDUtils.lerp(southHeightOffset, northHeightOffset, lerpY);
                            if (this.vertexIsLand.containsKey(vertexKeys[vertex])) continue;
                            this.vertexUnderwaterDepth.put(vertexKeys[vertex], heightOffset);
                        }
                    }
                }
            }
        }
    }

    public void calculateTerrainNormals(Scene scene) {
        this.vertexTerrainNormals = new HashMap<Integer, float[]>();
        Tile[][][] tiles = scene.getTiles();
        for (int tileZ = 0; tileZ < tiles.length; ++tileZ) {
            for (int tileX = 0; tileX < tiles[tileZ].length; ++tileX) {
                for (int tileY = 0; tileY < tiles[tileZ][tileX].length; ++tileY) {
                    if (tiles[tileZ][tileX][tileY] == null) continue;
                    boolean isBridge = false;
                    if (tiles[tileZ][tileX][tileY].getBridge() != null) {
                        this.calculateNormalsForTile(tiles[tileZ][tileX][tileY].getBridge(), false);
                        isBridge = true;
                    }
                    this.calculateNormalsForTile(tiles[tileZ][tileX][tileY], isBridge);
                }
            }
        }
    }

    void calculateNormalsForTile(Tile tile, boolean isBridge) {
        int[][] faceVertexKeys;
        int[][][] faceVertices;
        if (tile.getSceneTileModel() != null) {
            SceneTileModel tileModel = tile.getSceneTileModel();
            faceVertices = new int[tileModel.getFaceX().length][3][3];
            faceVertexKeys = new int[tileModel.getFaceX().length][3];
            for (int face = 0; face < tileModel.getFaceX().length; ++face) {
                int[][] vertices = this.faceVertices(tile, face);
                faceVertices[face][0] = new int[]{vertices[0][0], vertices[0][1], vertices[0][2]};
                faceVertices[face][2] = new int[]{vertices[1][0], vertices[1][1], vertices[1][2]};
                faceVertices[face][1] = new int[]{vertices[2][0], vertices[2][1], vertices[2][2]};
                int[] vertexKeys = this.faceVertexKeys(tile, face);
                faceVertexKeys[face][0] = vertexKeys[0];
                faceVertexKeys[face][2] = vertexKeys[1];
                faceVertexKeys[face][1] = vertexKeys[2];
            }
        } else {
            faceVertices = new int[2][3][3];
            faceVertexKeys = new int[3][3];
            int[][] vertices = this.tileVertices(tile);
            faceVertices[0] = new int[][]{vertices[3], vertices[1], vertices[2]};
            faceVertices[1] = new int[][]{vertices[0], vertices[2], vertices[1]};
            int[] vertexKeys = this.tileVertexKeys(tile);
            faceVertexKeys[0] = new int[]{vertexKeys[3], vertexKeys[1], vertexKeys[2]};
            faceVertexKeys[1] = new int[]{vertexKeys[0], vertexKeys[2], vertexKeys[1]};
        }
        for (int face = 0; face < faceVertices.length; ++face) {
            int[] vertexHeights = new int[]{faceVertices[face][0][2], faceVertices[face][1][2], faceVertices[face][2][2]};
            if (!isBridge) {
                vertexHeights[0] = vertexHeights[0] + this.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][0], 0);
                vertexHeights[1] = vertexHeights[1] + this.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][1], 0);
                vertexHeights[2] = vertexHeights[2] + this.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][2], 0);
            }
            float[] vertexNormals = HDUtils.calculateSurfaceNormals(new int[]{faceVertices[face][0][0], faceVertices[face][1][0], faceVertices[face][2][0]}, new int[]{faceVertices[face][0][1], faceVertices[face][1][1], faceVertices[face][2][1]}, new int[]{vertexHeights[0], vertexHeights[1], vertexHeights[2]});
            for (int vertex = 0; vertex < 3; ++vertex) {
                int vertexKey = faceVertexKeys[face][vertex];
                this.vertexTerrainNormals.merge(vertexKey, vertexNormals, (a, b) -> HDUtils.vectorAdd(b, a));
            }
        }
    }

    WaterType tileWaterType(Tile tile, SceneTilePaint sceneTilePaint) {
        if (tile.getBridge() != null) {
            return WaterType.NONE;
        }
        int tileZ = tile.getRenderLevel();
        int tileX = tile.getSceneLocation().getX();
        int tileY = tile.getSceneLocation().getY();
        WaterType waterType = WaterType.NONE;
        if (sceneTilePaint != null) {
            waterType = this.client.getScene().getOverlayIds()[tileZ][tileX][tileY] != 0 ? Overlay.getOverlay(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY], tile, this.client).getWaterType() : Underlay.getUnderlay(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY], tile, this.client).getWaterType();
        }
        waterType = this.getSeasonalWaterType(waterType);
        return waterType;
    }

    WaterType faceWaterType(Tile tile, int face, SceneTileModel sceneTileModel) {
        if (tile.getBridge() != null) {
            return WaterType.NONE;
        }
        int tileZ = tile.getRenderLevel();
        int tileX = tile.getSceneLocation().getX();
        int tileY = tile.getSceneLocation().getY();
        WaterType waterType = WaterType.NONE;
        if (sceneTileModel != null) {
            waterType = this.isOverlayFace(tile, face) ? Overlay.getOverlay(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY], tile, this.client).getWaterType() : Underlay.getUnderlay(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY], tile, this.client).getWaterType();
        }
        waterType = this.getSeasonalWaterType(waterType);
        return waterType;
    }

    boolean[] getTileOverlayTris(int tileShapeIndex) {
        if (tileShapeIndex >= this.tileOverlayTris.length) {
            log.debug("getTileOverlayTris(): unknown tileShapeIndex ({})", (Object)tileShapeIndex);
            return new boolean[]{false, false, false, false, false, false, false, false, false, false};
        }
        return this.tileOverlayTris[tileShapeIndex];
    }

    public boolean isOverlayFace(Tile tile, int face) {
        int tileShapeIndex = tile.getSceneTileModel().getShape() - 1;
        if (face >= this.getTileOverlayTris(tileShapeIndex).length) {
            return false;
        }
        return this.getTileOverlayTris(tileShapeIndex)[face];
    }

    int[][] tileVertices(Tile tile) {
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int z = tile.getRenderLevel();
        int[][][] tileHeights = this.client.getTileHeights();
        int[] swVertex = new int[]{x * 128, y * 128, tileHeights[z][x][y]};
        int[] seVertex = new int[]{(x + 1) * 128, y * 128, tileHeights[z][x + 1][y]};
        int[] nwVertex = new int[]{x * 128, (y + 1) * 128, tileHeights[z][x][y + 1]};
        int[] neVertex = new int[]{(x + 1) * 128, (y + 1) * 128, tileHeights[z][x + 1][y + 1]};
        return new int[][]{swVertex, seVertex, nwVertex, neVertex};
    }

    int[][] faceVertices(Tile tile, int face) {
        SceneTileModel sceneTileModel = tile.getSceneTileModel();
        int[] faceA = sceneTileModel.getFaceX();
        int[] faceB = sceneTileModel.getFaceY();
        int[] faceC = sceneTileModel.getFaceZ();
        int[] vertexX = sceneTileModel.getVertexX();
        int[] vertexY = sceneTileModel.getVertexY();
        int[] vertexZ = sceneTileModel.getVertexZ();
        int vertexFacesA = faceA[face];
        int vertexFacesB = faceB[face];
        int vertexFacesC = faceC[face];
        int sceneVertexXA = vertexX[vertexFacesA];
        int sceneVertexXB = vertexX[vertexFacesB];
        int sceneVertexXC = vertexX[vertexFacesC];
        int sceneVertexZA = vertexZ[vertexFacesA];
        int sceneVertexZB = vertexZ[vertexFacesB];
        int sceneVertexZC = vertexZ[vertexFacesC];
        int sceneVertexYA = vertexY[vertexFacesA];
        int sceneVertexYB = vertexY[vertexFacesB];
        int sceneVertexYC = vertexY[vertexFacesC];
        int[] vertexA = new int[]{sceneVertexXA, sceneVertexZA, sceneVertexYA};
        int[] vertexB = new int[]{sceneVertexXB, sceneVertexZB, sceneVertexYB};
        int[] vertexC = new int[]{sceneVertexXC, sceneVertexZC, sceneVertexYC};
        return new int[][]{vertexA, vertexB, vertexC};
    }

    int[][] tileLocalVertices(Tile tile) {
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int z = tile.getRenderLevel();
        int[][][] tileHeights = this.client.getTileHeights();
        int[] swVertex = new int[]{0, 0, tileHeights[z][x][y]};
        int[] seVertex = new int[]{128, 0, tileHeights[z][x + 1][y]};
        int[] nwVertex = new int[]{0, 128, tileHeights[z][x][y + 1]};
        int[] neVertex = new int[]{128, 128, tileHeights[z][x + 1][y + 1]};
        return new int[][]{swVertex, seVertex, nwVertex, neVertex};
    }

    int[][] faceLocalVertices(Tile tile, int face) {
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int baseX = x * 128;
        int baseY = y * 128;
        if (tile.getSceneTileModel() == null) {
            return new int[0][0];
        }
        SceneTileModel sceneTileModel = tile.getSceneTileModel();
        int[] faceA = sceneTileModel.getFaceX();
        int[] faceB = sceneTileModel.getFaceY();
        int[] faceC = sceneTileModel.getFaceZ();
        int[] vertexX = sceneTileModel.getVertexX();
        int[] vertexY = sceneTileModel.getVertexY();
        int[] vertexZ = sceneTileModel.getVertexZ();
        int vertexFacesA = faceA[face];
        int vertexFacesB = faceB[face];
        int vertexFacesC = faceC[face];
        int sceneVertexXA = vertexX[vertexFacesA];
        int sceneVertexXB = vertexX[vertexFacesB];
        int sceneVertexXC = vertexX[vertexFacesC];
        int sceneVertexZA = vertexZ[vertexFacesA];
        int sceneVertexZB = vertexZ[vertexFacesB];
        int sceneVertexZC = vertexZ[vertexFacesC];
        int sceneVertexYA = vertexY[vertexFacesA];
        int sceneVertexYB = vertexY[vertexFacesB];
        int sceneVertexYC = vertexY[vertexFacesC];
        int[] vertexA = new int[]{sceneVertexXA - baseX, sceneVertexZA - baseY, sceneVertexYA};
        int[] vertexB = new int[]{sceneVertexXB - baseX, sceneVertexZB - baseY, sceneVertexYB};
        int[] vertexC = new int[]{sceneVertexXC - baseX, sceneVertexZC - baseY, sceneVertexYC};
        return new int[][]{vertexA, vertexB, vertexC};
    }

    int[] tileVertexKeys(Tile tile) {
        int[][] tileVertices = this.tileVertices(tile);
        int[] vertexHashes = new int[tileVertices.length];
        for (int vertex = 0; vertex < tileVertices.length; ++vertex) {
            vertexHashes[vertex] = HDUtils.vertexHash(tileVertices[vertex]);
        }
        return vertexHashes;
    }

    int[] faceVertexKeys(Tile tile, int face) {
        int[][] faceVertices = this.faceVertices(tile, face);
        int[] vertexHashes = new int[faceVertices.length];
        for (int vertex = 0; vertex < faceVertices.length; ++vertex) {
            vertexHashes[vertex] = HDUtils.vertexHash(faceVertices[vertex]);
        }
        return vertexHashes;
    }

    public int[] recolorOverlay(Overlay overlay, int[] colorHSL) {
        colorHSL[0] = overlay.getHue() >= 0 ? overlay.getHue() : colorHSL[0];
        colorHSL[0] = colorHSL[0] + overlay.getShiftHue();
        colorHSL[0] = Ints.constrainToRange(colorHSL[0], 0, 63);
        colorHSL[1] = overlay.getSaturation() >= 0 ? overlay.getSaturation() : colorHSL[1];
        colorHSL[1] = colorHSL[1] + overlay.getShiftSaturation();
        colorHSL[1] = Ints.constrainToRange(colorHSL[1], 0, 7);
        colorHSL[2] = overlay.getLightness() >= 0 ? overlay.getLightness() : colorHSL[2];
        colorHSL[2] = colorHSL[2] + overlay.getShiftLightness();
        colorHSL[2] = Ints.constrainToRange(colorHSL[2], 0, 127);
        return colorHSL;
    }

    public int[] recolorUnderlay(Underlay underlay, int[] colorHSL) {
        colorHSL[0] = underlay.getHue() >= 0 ? underlay.getHue() : colorHSL[0];
        colorHSL[0] = colorHSL[0] + underlay.getShiftHue();
        colorHSL[0] = Ints.constrainToRange(colorHSL[0], 0, 63);
        colorHSL[1] = underlay.getSaturation() >= 0 ? underlay.getSaturation() : colorHSL[1];
        colorHSL[1] = colorHSL[1] + underlay.getShiftSaturation();
        colorHSL[1] = Ints.constrainToRange(colorHSL[1], 0, 7);
        colorHSL[2] = underlay.getLightness() >= 0 ? underlay.getLightness() : colorHSL[2];
        colorHSL[2] = colorHSL[2] + underlay.getShiftLightness();
        colorHSL[2] = Ints.constrainToRange(colorHSL[2], 0, 127);
        return colorHSL;
    }

    boolean useDefaultColor(Tile tile) {
        int z = tile.getRenderLevel();
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        if (tile.getSceneTilePaint() != null && tile.getSceneTilePaint().getTexture() >= 0 || tile.getSceneTileModel() != null && tile.getSceneTileModel().getTriangleTextureId() != null) {
            return true;
        }
        return this.client.getScene().getOverlayIds()[z][x][y] != 0 ? !Overlay.getOverlay(this.client.getScene().getOverlayIds()[z][x][y], tile, this.client).isBlended() : this.client.getScene().getUnderlayIds()[z][x][y] != 0 && !Underlay.getUnderlay(this.client.getScene().getUnderlayIds()[z][x][y], tile, this.client).isBlended();
    }

    public Underlay getSeasonalUnderlay(Underlay underlay) {
        if (this.hdPlugin.configWinterTheme) {
            switch (underlay.getGroundMaterial()) {
                case OVERWORLD_GRASS_1: {
                    underlay = Underlay.WINTER_GRASS;
                    break;
                }
                case OVERWORLD_DIRT: {
                    underlay = Underlay.WINTER_DIRT;
                }
            }
        }
        return underlay;
    }

    public Overlay getSeasonalOverlay(Overlay overlay) {
        if (this.hdPlugin.configWinterTheme) {
            switch (overlay.getGroundMaterial()) {
                case OVERWORLD_GRASS_1: {
                    overlay = Overlay.WINTER_GRASS;
                }
            }
        }
        return overlay;
    }

    WaterType getSeasonalWaterType(WaterType waterType) {
        if (this.hdPlugin.configWinterTheme) {
            switch (waterType) {
                case WATER: {
                    waterType = WaterType.ICE;
                }
            }
        }
        return waterType;
    }

    public Material getSeasonalMaterial(Material material) {
        if (this.hdPlugin.configWinterTheme) {
            switch (material) {
                case LEAVES_1: {
                    material = Material.WINTER_LEAVES_1;
                    break;
                }
                case WILLOW_LEAVES: {
                    material = Material.WINTER_WILLOW_LEAVES;
                    break;
                }
                case MAPLE_LEAVES: {
                    material = Material.WINTER_MAPLE_LEAVES;
                    break;
                }
                case LEAVES_2: {
                    material = Material.WINTER_LEAVES_2;
                    break;
                }
                case LEAVES_3: {
                    material = Material.WINTER_LEAVES_3;
                    break;
                }
                case PAINTING_LANDSCAPE: {
                    material = Material.WINTER_PAINTING_LANDSCAPE;
                    break;
                }
                case PAINTING_KING: {
                    material = Material.WINTER_PAINTING_KING;
                    break;
                }
                case PAINTING_ELF: {
                    material = Material.WINTER_PAINTING_ELF;
                }
            }
        }
        return material;
    }

    public int[][] recolorTzHaar(ObjectProperties objectProperties, int aY, int bY, int cY, int packedAlphaPriority, ObjectType objectType, int color1H, int color1S, int color1L, int color2H, int color2S, int color2L, int color3H, int color3S, int color3L) {
        int hue;
        if (objectType == ObjectType.GROUND_OBJECT && color1S <= 1) {
            packedAlphaPriority = -16777216;
        }
        color1H = hue = 7;
        color2H = hue;
        color3H = hue;
        if (objectProperties.getTzHaarRecolorType() == TzHaarRecolorType.GRADIENT) {
            float pos;
            if (color1L < 20) {
                pos = Floats.constrainToRange((float)(aY - -200) / 200.0f, 0.0f, 1.0f);
                color1H = (int)HDUtils.lerp(this.gradientDarkColor[0], this.gradientBaseColor[0], pos);
                color1S = (int)HDUtils.lerp(this.gradientDarkColor[1], this.gradientBaseColor[1], pos);
                color1L = (int)HDUtils.lerp(this.gradientDarkColor[2], this.gradientBaseColor[2], pos);
            }
            if (color2L < 20) {
                pos = Floats.constrainToRange((float)(bY - -200) / 200.0f, 0.0f, 1.0f);
                color2H = (int)HDUtils.lerp(this.gradientDarkColor[0], this.gradientBaseColor[0], pos);
                color2S = (int)HDUtils.lerp(this.gradientDarkColor[1], this.gradientBaseColor[1], pos);
                color2L = (int)HDUtils.lerp(this.gradientDarkColor[2], this.gradientBaseColor[2], pos);
            }
            if (color3L < 20) {
                pos = Floats.constrainToRange((float)(cY - -200) / 200.0f, 0.0f, 1.0f);
                color3H = (int)HDUtils.lerp(this.gradientDarkColor[0], this.gradientBaseColor[0], pos);
                color3S = (int)HDUtils.lerp(this.gradientDarkColor[1], this.gradientBaseColor[1], pos);
                color3L = (int)HDUtils.lerp(this.gradientDarkColor[2], this.gradientBaseColor[2], pos);
            }
        } else if (objectProperties.getTzHaarRecolorType() == TzHaarRecolorType.HUE_SHIFT) {
            // empty if block
        }
        this.tzHaarRecolored[0][0] = color1H;
        this.tzHaarRecolored[0][1] = color1S;
        this.tzHaarRecolored[0][2] = ++color1L;
        this.tzHaarRecolored[1][0] = color2H;
        this.tzHaarRecolored[1][1] = color2S;
        this.tzHaarRecolored[1][2] = ++color2L;
        this.tzHaarRecolored[2][0] = color3H;
        this.tzHaarRecolored[2][1] = color3S;
        this.tzHaarRecolored[2][2] = ++color3L;
        this.tzHaarRecolored[3][0] = packedAlphaPriority;
        return this.tzHaarRecolored;
    }
}

