/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.config.DefaultSkyColor;
import net.runelite.client.plugins.hd.data.environments.Environment;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.Rect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnvironmentManager {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentManager.class);
    @Inject
    private Client client;
    @Inject
    private HdPluginConfig config;
    @Inject
    private HdPlugin hdPlugin;
    private ArrayList<Environment> sceneEnvironments;
    private Environment currentEnvironment;
    private final Environment defaultEnvironment = Environment.OVERWORLD;
    private final int transitionDuration = 3000;
    private final int skipTransitionTiles = 41;
    private long startTime = 0L;
    private long transitionCompleteTime = 0L;
    long lastFrameTime = -1L;
    DefaultSkyColor lastSkyColor = DefaultSkyColor.DEFAULT;
    boolean lastEnvironmentLighting = true;
    boolean lastSkyOverride = false;
    boolean lastUnderwater = false;
    private int prevCamTargetX = 0;
    private int prevCamTargetY = 0;
    public static final float[] BLACK_COLOR = new float[]{0.0f, 0.0f, 0.0f};
    private float[] startFogColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentFogColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetFogColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] startWaterColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentWaterColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetWaterColor = new float[]{0.0f, 0.0f, 0.0f};
    private int startFogDepth = 0;
    public int currentFogDepth = 0;
    private int targetFogDepth = 0;
    private float startAmbientStrength = 0.0f;
    public float currentAmbientStrength = 0.0f;
    private float targetAmbientStrength = 0.0f;
    private float[] startAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startDirectionalStrength = 0.0f;
    public float currentDirectionalStrength = 0.0f;
    private float targetDirectionalStrength = 0.0f;
    private float[] startUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startUnderwaterCausticsStrength = 1.0f;
    public float currentUnderwaterCausticsStrength = 1.0f;
    private float targetUnderwaterCausticsStrength = 1.0f;
    private float[] startDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startUnderglowStrength = 0.0f;
    public float currentUnderglowStrength = 0.0f;
    private float targetUnderglowStrength = 0.0f;
    private float[] startUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startGroundFogStart = 0.0f;
    public float currentGroundFogStart = 0.0f;
    private float targetGroundFogStart = 0.0f;
    private float startGroundFogEnd = 0.0f;
    public float currentGroundFogEnd = 0.0f;
    private float targetGroundFogEnd = 0.0f;
    private float startGroundFogOpacity = 0.0f;
    public float currentGroundFogOpacity = 0.0f;
    private float targetGroundFogOpacity = 0.0f;
    private float startLightPitch = 0.0f;
    public float currentLightPitch = 0.0f;
    private float targetLightPitch = 0.0f;
    private float startLightYaw = 0.0f;
    public float currentLightYaw = 0.0f;
    private float targetLightYaw = 0.0f;
    public boolean lightningEnabled = false;
    public float lightningBrightness = 0.0f;
    public float[] lightningColor = new float[]{1.0f, 1.0f, 1.0f};
    double nextLightningTime = -1.0;
    float newLightningBrightness = 7.0f;
    float lightningFadeSpeed = 80.0f;
    int minLightningInterval = 5500;
    int maxLightningInterval = 17000;
    float quickLightningChance = 2.0f;
    int minQuickLightningInterval = 40;
    int maxQuickLightningInterval = 150;

    public void update() {
        long currentTime;
        WorldPoint camPosition = this.localPointToWorldTile(this.hdPlugin.camTarget[0], this.hdPlugin.camTarget[1]);
        int camTargetX = camPosition.getX();
        int camTargetY = camPosition.getY();
        int camTargetZ = camPosition.getPlane();
        for (Environment environment : this.sceneEnvironments) {
            if (!environment.getArea().containsPoint(camTargetX, camTargetY, camTargetZ)) continue;
            if (environment == this.currentEnvironment) break;
            if (environment == Environment.PLAYER_OWNED_HOUSE || environment == Environment.PLAYER_OWNED_HOUSE_SNOWY) {
                this.hdPlugin.setInHouse(true);
                this.hdPlugin.setNextSceneReload(System.currentTimeMillis() + 2500L);
            } else {
                this.hdPlugin.setInHouse(false);
            }
            this.hdPlugin.setInGauntlet(environment == Environment.THE_GAUNTLET || environment == Environment.THE_GAUNTLET_CORRUPTED);
            this.changeEnvironment(environment, camTargetX, camTargetY, false);
            break;
        }
        if (this.lastSkyColor != this.config.defaultSkyColor() || this.lastEnvironmentLighting != this.config.atmosphericLighting() || this.lastSkyOverride != this.config.overrideSky() || this.lastUnderwater != this.isUnderwater()) {
            this.changeEnvironment(this.currentEnvironment, camTargetX, camTargetY, true);
        }
        if ((currentTime = System.currentTimeMillis()) >= this.transitionCompleteTime) {
            this.currentFogColor = this.targetFogColor;
            this.currentWaterColor = this.targetWaterColor;
            this.currentFogDepth = this.targetFogDepth;
            this.currentAmbientStrength = this.targetAmbientStrength;
            this.currentAmbientColor = this.targetAmbientColor;
            this.currentDirectionalStrength = this.targetDirectionalStrength;
            this.currentDirectionalColor = this.targetDirectionalColor;
            this.currentUnderglowStrength = this.targetUnderglowStrength;
            this.currentUnderglowColor = this.targetUnderglowColor;
            this.currentGroundFogStart = this.targetGroundFogStart;
            this.currentGroundFogEnd = this.targetGroundFogEnd;
            this.currentGroundFogOpacity = this.targetGroundFogOpacity;
            this.currentLightPitch = this.targetLightPitch;
            this.currentLightYaw = this.targetLightYaw;
            this.currentUnderwaterCausticsColor = this.targetUnderwaterCausticsColor;
            this.currentUnderwaterCausticsStrength = this.targetUnderwaterCausticsStrength;
        } else {
            float t = (float)(currentTime - this.startTime) / 3000.0f;
            this.currentFogColor = HDUtils.lerpVectors(this.startFogColor, this.targetFogColor, t);
            this.currentWaterColor = HDUtils.lerpVectors(this.startWaterColor, this.targetWaterColor, t);
            this.currentFogDepth = (int)HDUtils.lerp(this.startFogDepth, this.targetFogDepth, t);
            this.currentAmbientStrength = HDUtils.lerp(this.startAmbientStrength, this.targetAmbientStrength, t);
            this.currentAmbientColor = HDUtils.lerpVectors(this.startAmbientColor, this.targetAmbientColor, t);
            this.currentDirectionalStrength = HDUtils.lerp(this.startDirectionalStrength, this.targetDirectionalStrength, t);
            this.currentDirectionalColor = HDUtils.lerpVectors(this.startDirectionalColor, this.targetDirectionalColor, t);
            this.currentUnderglowStrength = HDUtils.lerp(this.startUnderglowStrength, this.targetUnderglowStrength, t);
            this.currentUnderglowColor = HDUtils.lerpVectors(this.startUnderglowColor, this.targetUnderglowColor, t);
            this.currentGroundFogStart = HDUtils.lerp(this.startGroundFogStart, this.targetGroundFogStart, t);
            this.currentGroundFogEnd = HDUtils.lerp(this.startGroundFogEnd, this.targetGroundFogEnd, t);
            this.currentGroundFogOpacity = HDUtils.lerp(this.startGroundFogOpacity, this.targetGroundFogOpacity, t);
            this.currentLightPitch = HDUtils.lerp(this.startLightPitch, this.targetLightPitch, t);
            this.currentLightYaw = HDUtils.lerp(this.startLightYaw, this.targetLightYaw, t);
            this.currentUnderwaterCausticsColor = HDUtils.lerpVectors(this.startUnderwaterCausticsColor, this.targetUnderwaterCausticsColor, t);
            this.currentUnderwaterCausticsStrength = HDUtils.lerp(this.startUnderwaterCausticsStrength, this.targetUnderwaterCausticsStrength, t);
        }
        this.updateLightning();
        this.prevCamTargetX = camTargetX;
        this.prevCamTargetY = camTargetY;
        this.lastFrameTime = System.currentTimeMillis();
        this.lastSkyColor = this.config.defaultSkyColor();
        this.lastSkyOverride = this.config.overrideSky();
        this.lastEnvironmentLighting = this.config.atmosphericLighting();
        this.lastUnderwater = this.isUnderwater();
    }

    private void changeEnvironment(Environment newEnvironment, int camTargetX, int camTargetY, boolean instantChange) {
        int tileChangeY;
        this.currentEnvironment = newEnvironment;
        log.debug("currentEnvironment changed to " + (Object)((Object)newEnvironment));
        this.startTime = System.currentTimeMillis();
        this.transitionCompleteTime = instantChange ? 0L : this.startTime + 3000L;
        this.startFogColor = this.currentFogColor;
        this.startWaterColor = this.currentWaterColor;
        this.startFogDepth = this.currentFogDepth;
        this.startAmbientStrength = this.currentAmbientStrength;
        this.startAmbientColor = this.currentAmbientColor;
        this.startDirectionalStrength = this.currentDirectionalStrength;
        this.startDirectionalColor = this.currentDirectionalColor;
        this.startUnderglowStrength = this.currentUnderglowStrength;
        this.startUnderglowColor = this.currentUnderglowColor;
        this.startGroundFogStart = this.currentGroundFogStart;
        this.startGroundFogEnd = this.currentGroundFogEnd;
        this.startGroundFogOpacity = this.currentGroundFogOpacity;
        this.startLightPitch = this.currentLightPitch;
        this.startLightYaw = this.currentLightYaw;
        this.startUnderwaterCausticsColor = this.currentUnderwaterCausticsColor;
        this.startUnderwaterCausticsStrength = this.currentUnderwaterCausticsStrength;
        this.updateSkyColor();
        this.targetFogDepth = newEnvironment.getFogDepth();
        if (this.hdPlugin.configWinterTheme && !newEnvironment.isCustomFogDepth()) {
            this.targetFogDepth = Environment.WINTER.getFogDepth();
        }
        if (this.config.atmosphericLighting()) {
            this.targetAmbientStrength = newEnvironment.getAmbientStrength();
            this.targetAmbientColor = newEnvironment.getAmbientColor();
            this.targetDirectionalStrength = newEnvironment.getDirectionalStrength();
            this.targetDirectionalColor = newEnvironment.getDirectionalColor();
            this.targetUnderglowStrength = newEnvironment.getUnderglowStrength();
            this.targetUnderglowColor = newEnvironment.getUnderglowColor();
            this.targetLightPitch = newEnvironment.getLightPitch();
            this.targetLightYaw = newEnvironment.getLightYaw();
            if (this.hdPlugin.configWinterTheme) {
                if (!newEnvironment.isCustomAmbientStrength()) {
                    this.targetAmbientStrength = Environment.WINTER.getAmbientStrength();
                }
                if (!newEnvironment.isCustomAmbientColor()) {
                    this.targetAmbientColor = Environment.WINTER.getAmbientColor();
                }
                if (!newEnvironment.isCustomDirectionalStrength()) {
                    this.targetDirectionalStrength = Environment.WINTER.getDirectionalStrength();
                }
                if (!newEnvironment.isCustomDirectionalColor()) {
                    this.targetDirectionalColor = Environment.WINTER.getDirectionalColor();
                }
            }
        } else {
            this.targetAmbientStrength = this.defaultEnvironment.getAmbientStrength();
            this.targetAmbientColor = this.defaultEnvironment.getAmbientColor();
            this.targetDirectionalStrength = this.defaultEnvironment.getDirectionalStrength();
            this.targetDirectionalColor = this.defaultEnvironment.getDirectionalColor();
            this.targetUnderglowStrength = this.defaultEnvironment.getUnderglowStrength();
            this.targetUnderglowColor = this.defaultEnvironment.getUnderglowColor();
            this.targetLightPitch = this.defaultEnvironment.getLightPitch();
            this.targetLightYaw = this.defaultEnvironment.getLightYaw();
            if (this.hdPlugin.configWinterTheme) {
                if (!this.defaultEnvironment.isCustomAmbientStrength()) {
                    this.targetAmbientStrength = Environment.WINTER.getAmbientStrength();
                }
                if (!this.defaultEnvironment.isCustomAmbientColor()) {
                    this.targetAmbientColor = Environment.WINTER.getAmbientColor();
                }
                if (!this.defaultEnvironment.isCustomDirectionalStrength()) {
                    this.targetDirectionalStrength = Environment.WINTER.getDirectionalStrength();
                }
                if (!this.defaultEnvironment.isCustomDirectionalColor()) {
                    this.targetDirectionalColor = Environment.WINTER.getDirectionalColor();
                }
            }
        }
        this.targetGroundFogStart = newEnvironment.getGroundFogStart();
        this.targetGroundFogEnd = newEnvironment.getGroundFogEnd();
        this.targetGroundFogOpacity = newEnvironment.getGroundFogOpacity();
        this.targetUnderwaterCausticsColor = newEnvironment.getUnderwaterCausticsColor();
        this.targetUnderwaterCausticsStrength = newEnvironment.getUnderwaterCausticsStrength();
        this.lightningEnabled = newEnvironment.isLightningEnabled();
        int tileChangeX = Math.abs(this.prevCamTargetX - camTargetX);
        int tileChange = Math.max(tileChangeX, tileChangeY = Math.abs(this.prevCamTargetY - camTargetY));
        if (tileChange >= 41) {
            this.transitionCompleteTime = this.startTime;
        }
    }

    public void updateSkyColor() {
        Environment env;
        Environment environment = env = this.hdPlugin.configWinterTheme ? Environment.WINTER : this.currentEnvironment;
        if (!env.isCustomFogColor() || env.isAllowSkyOverride() && this.config.overrideSky()) {
            DefaultSkyColor sky = this.config.defaultSkyColor();
            this.targetFogColor = sky.getRgb(this.client);
            if (sky == DefaultSkyColor.OSRS) {
                sky = DefaultSkyColor.DEFAULT;
            }
            this.targetWaterColor = sky.getRgb(this.client);
        } else {
            this.targetWaterColor = env.getFogColor();
            this.targetFogColor = this.targetWaterColor;
        }
        if (this.currentEnvironment.isCustomWaterColor()) {
            this.targetWaterColor = this.currentEnvironment.getWaterColor();
        }
    }

    public void loadSceneEnvironments() {
        this.sceneEnvironments = new ArrayList();
        int sceneMinX = this.client.getBaseX();
        int sceneMinY = this.client.getBaseY();
        if (this.client.isInInstancedRegion()) {
            LocalPoint localPoint = this.client.getLocalPlayer() != null ? this.client.getLocalPlayer().getLocalLocation() : new LocalPoint(0, 0);
            WorldPoint worldPoint = WorldPoint.fromLocalInstance(this.client, localPoint);
            sceneMinX = worldPoint.getX() - localPoint.getSceneX();
            sceneMinY = worldPoint.getY() - localPoint.getSceneY();
        }
        int sceneMaxX = sceneMinX + 104 - 2;
        int sceneMaxY = sceneMinY + 104 - 2;
        log.debug("adding environments for scene {},{} - {},{}..", sceneMinX, sceneMinY, sceneMaxX, sceneMaxY);
        block0: for (Environment environment : Environment.values()) {
            for (Rect rect : environment.getArea().getRects()) {
                if (rect.getMinX() > sceneMaxX || sceneMinX > rect.getMaxX() || rect.getMinY() > sceneMaxY || sceneMinY > rect.getMaxY()) continue;
                log.debug("added environment {} to sceneArea list", (Object)environment.name());
                this.sceneEnvironments.add(environment);
                continue block0;
            }
        }
        for (Environment environment : this.sceneEnvironments) {
            log.debug("sceneArea: " + environment.name());
        }
        if (this.currentEnvironment != null) {
            WorldPoint camPosition = this.localPointToWorldTile(this.hdPlugin.camTarget[0], this.hdPlugin.camTarget[1]);
            int camTargetX = camPosition.getX();
            int camTargetY = camPosition.getY();
            this.changeEnvironment(this.currentEnvironment, camTargetX, camTargetY, false);
        }
    }

    void updateLightning() {
        if (this.lightningBrightness > 0.0f) {
            int frameTime = (int)(System.currentTimeMillis() - this.lastFrameTime);
            float brightnessChange = (float)frameTime / 1000.0f * this.lightningFadeSpeed;
            this.lightningBrightness = Math.max(this.lightningBrightness - brightnessChange, 0.0f);
        }
        if (this.nextLightningTime == -1.0) {
            this.generateNextLightningTime();
            return;
        }
        if ((double)System.currentTimeMillis() > this.nextLightningTime) {
            this.lightningBrightness = this.newLightningBrightness;
            this.generateNextLightningTime();
        }
        if (this.lightningEnabled && this.config.flashingEffects()) {
            float t = Floats.constrainToRange(this.lightningBrightness, 0.0f, 1.0f);
            this.currentFogColor = HDUtils.lerpVectors(this.currentFogColor, this.lightningColor, t);
            this.currentWaterColor = HDUtils.lerpVectors(this.currentWaterColor, this.lightningColor, t);
        } else {
            this.lightningBrightness = 0.0f;
        }
    }

    void generateNextLightningTime() {
        int lightningInterval = (int)((double)this.minLightningInterval + (double)(this.maxLightningInterval - this.minLightningInterval) * Math.random());
        int quickLightningInterval = (int)((double)this.minQuickLightningInterval + (double)(this.maxQuickLightningInterval - this.minQuickLightningInterval) * Math.random());
        this.nextLightningTime = Math.random() <= (double)(1.0f / this.quickLightningChance) ? (double)(System.currentTimeMillis() + (long)quickLightningInterval) : (double)(System.currentTimeMillis() + (long)lightningInterval);
    }

    public float[] getFogColor() {
        return Arrays.copyOf(this.client.getGameState().getState() >= GameState.LOADING.getState() ? this.currentFogColor : BLACK_COLOR, 3);
    }

    WorldPoint localPointToWorldTile(int pointX, int pointY) {
        int[][][] instanceTemplateChunks = this.client.getInstanceTemplateChunks();
        LocalPoint localPoint = new LocalPoint(pointX, pointY);
        int chunkX = localPoint.getSceneX() / 8;
        int chunkY = localPoint.getSceneY() / 8;
        if (this.client.isInInstancedRegion() && chunkX >= 0 && chunkX < instanceTemplateChunks[this.client.getPlane()].length && chunkY >= 0 && chunkY < instanceTemplateChunks[this.client.getPlane()][chunkX].length) {
            return WorldPoint.fromLocalInstance(this.client, localPoint);
        }
        return WorldPoint.fromLocal(this.client, localPoint);
    }

    public boolean isUnderwater() {
        return this.currentEnvironment != null && this.currentEnvironment.isUnderwater();
    }
}

