/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.data.materials;

import java.util.Arrays;
import java.util.HashMap;

public enum Material {
    NONE(-1),
    TRAPDOOR(0),
    WATER_FLAT(1),
    BRICK(2),
    WOOD_PLANKS_1(3, new Properties().setSpecular(0.35f, 30.0f)),
    DOOR(4),
    DARK_WOOD(5),
    ROOF_SHINGLES_1(6, new Properties().setSpecular(0.5f, 30.0f)),
    TEXTURE_7(7),
    LEAVES_1(8, new Properties().setTextureScale(1.3f, 1.0f)),
    TEXTURE_9(9),
    TEXTURE_10(10),
    CONCRETE(11),
    IRON_FENCE(12),
    PAINTING_LANDSCAPE(13),
    PAINTING_KING(14),
    MARBLE_DARK(15, new Properties().setSpecular(1.1f, 380.0f)),
    TEXTURE_16(16),
    TEXTURE_17(17),
    STRAW(18),
    NET(19),
    BOOKCASE(20),
    TEXTURE_21(21),
    WOOD_PLANKS_2(22, new Properties().setSpecular(0.35f, 30.0f)),
    BRICK_BROWN(23),
    WATER_FLAT_2(24),
    SWAMP_WATER_FLAT(25),
    SPIDER_WEB(26),
    TEXTURE_27(27),
    MOSS(28),
    PALM_LEAF(29),
    WILLOW_LEAVES(30, new Properties().setTextureScale(1.025f, 1.0f)),
    LAVA(31, new Properties().setEmissive(1.0f).setDisplacement(235, 0.05f, 36.0f, 22.0f).setScroll(0.0f, 3.0f)),
    TEXTURE_32(32),
    MAPLE_LEAVES(33, new Properties().setTextureScale(1.3f, 1.0f)),
    MAGIC_STARS(34, new Properties().setEmissive(1.0f)),
    SAND_BRICK(35),
    TEXTURE_36(36),
    CHAIN(37),
    TEXTURE_38(38),
    PAINTING_ELF(39),
    FIRE_CAPE(40, new Properties().setEmissive(1.0f).setDisplacement(235, 0.05f, 12.0f, 4.0f).setScroll(0.0f, -3.0f)),
    LEAVES_2(41, new Properties().setTextureScale(1.1f, 1.1f)),
    MARBLE(42, new Properties().setSpecular(1.0f, 400.0f)),
    TILE_DARK(43),
    ROOF_SHINGLES_2(44),
    TEXTURE_45(45),
    STONE_PATTERN(46),
    TEXTURE_47(47),
    HIEROGLYPHICS(48),
    TEXTURE_49(49),
    TEXTURE_50(50),
    TEXTURE_51(51),
    SNOW_FLAKES(52),
    TEXTURE_53(53),
    TEXTURE_54(54),
    TEXTURE_55(55),
    TEXTURE_56(56),
    TEXTURE_57(57),
    TEXTURE_58(58),
    INFERNAL_CAPE(59, new Properties().setEmissive(1.0f).setDisplacement(235, 0.02f, 12.0f, 4.0f).setScroll(0.0f, 0.0f)),
    LEAVES_3(60),
    TEXTURE_61(61),
    TEXTURE_62(62),
    TEXTURE_63(63),
    TEXTURE_64(64),
    TEXTURE_65(65),
    TEXTURE_66(66),
    TEXTURE_67(67),
    TEXTURE_68(68),
    TEXTURE_69(69),
    TEXTURE_70(70),
    TEXTURE_71(71),
    TEXTURE_72(72),
    TEXTURE_73(73),
    TEXTURE_74(74),
    TEXTURE_75(75),
    TEXTURE_76(76),
    TEXTURE_77(77),
    TEXTURE_78(78),
    TEXTURE_79(79),
    TEXTURE_80(80),
    TEXTURE_81(81),
    TEXTURE_82(82),
    TEXTURE_83(83),
    TEXTURE_84(84),
    TEXTURE_85(85),
    TEXTURE_86(86),
    TEXTURE_87(87),
    TEXTURE_88(88),
    SHAYZIEN_LEAVES_1(89),
    SHAYZIEN_LEAVES_2(90, new Properties().setTextureScale(1.1f, 1.1f)),
    TEXTURE_91(91),
    TEXTURE_92(92),
    TEXTURE_93(93),
    TEXTURE_94(94),
    TEXTURE_95(95),
    TEXTURE_96(96),
    TEXTURE_97(97),
    TEXTURE_98(98),
    TEXTURE_99(99),
    TEXTURE_100(100),
    TEXTURE_101(101),
    TEXTURE_102(102),
    TEXTURE_103(103),
    TEXTURE_104(104),
    TEXTURE_105(105),
    TEXTURE_106(106),
    TEXTURE_107(107),
    TEXTURE_108(108),
    TEXTURE_109(109),
    TEXTURE_110(110),
    TEXTURE_111(111),
    TEXTURE_112(112),
    TEXTURE_113(113),
    TEXTURE_114(114),
    TEXTURE_115(115),
    TEXTURE_116(116),
    TEXTURE_117(117),
    TEXTURE_118(118),
    TEXTURE_119(119),
    TEXTURE_120(120),
    TEXTURE_121(121),
    TEXTURE_122(122),
    TEXTURE_123(123),
    TEXTURE_124(124),
    TEXTURE_125(125),
    TEXTURE_126(126),
    TEXTURE_127(127),
    WHITE(200),
    GRAY_25(201),
    GRAY_50(202),
    GRAY_75(203),
    BLACK(204),
    BLANK_GLOSS(200, new Properties().setSpecular(0.9f, 280.0f)),
    BLANK_SEMIGLOSS(200, new Properties().setSpecular(0.35f, 80.0f)),
    SNOW_1(205),
    SNOW_2(206),
    SNOW_3(207),
    SNOW_4(208),
    GRASS_1(209),
    GRASS_2(210),
    GRASS_3(211),
    GRASS_SCROLLING(209, new Properties().setScroll(0.0f, 0.7f)),
    DIRT_1(213),
    DIRT_2(214),
    GRAVEL(215),
    DIRT_SHINY_1(213, new Properties().setSpecular(1.1f, 380.0f)),
    DIRT_SHINY_2(214, new Properties().setSpecular(1.1f, 380.0f)),
    GRAVEL_SHINY(215, new Properties().setSpecular(1.1f, 380.0f)),
    SAND_1(218),
    SAND_2(219),
    SAND_3(220),
    GRUNGE_1(221),
    GRUNGE_2(222),
    ROCK_1(223),
    ROCK_2(224),
    CARPET(225),
    FALADOR_PATH_BRICK(226, new Properties().setSpecular(0.3f, 30.0f)),
    JAGGED_STONE_TILE(227),
    TILE_SMALL_1(228, new Properties().setSpecular(0.8f, 70.0f)),
    TILES_1_2x2(229, new Properties()),
    TILES_2_2x2(230, new Properties()),
    TILES_2x2_1_GLOSS(229, new Properties().setSpecular(1.0f, 70.0f)),
    TILES_2x2_2_GLOSS(230, new Properties().setSpecular(1.0f, 70.0f)),
    TILES_2x2_1_SEMIGLOSS(229, new Properties().setSpecular(0.5f, 300.0f)),
    TILES_2x2_2_SEMIGLOSS(230, new Properties().setSpecular(0.5f, 300.0f)),
    MARBLE_1(231),
    MARBLE_2(232),
    MARBLE_3(234),
    MARBLE_1_GLOSS(231, new Properties().setSpecular(0.9f, 280.0f)),
    MARBLE_2_GLOSS(232, new Properties().setSpecular(0.8f, 300.0f)),
    MARBLE_3_GLOSS(234, new Properties().setSpecular(0.7f, 320.0f)),
    MARBLE_1_SEMIGLOSS(231, new Properties().setSpecular(0.35f, 80.0f)),
    MARBLE_2_SEMIGLOSS(232, new Properties().setSpecular(0.3f, 100.0f)),
    MARBLE_3_SEMIGLOSS(234, new Properties().setSpecular(0.4f, 120.0f)),
    HD_LAVA_1(241, new Properties().setEmissive(1.0f).setDisplacement(235, 0.04f, 36.0f, 12.0f)),
    HD_LAVA_2(242, new Properties().setEmissive(1.0f).setDisplacement(235, 0.04f, 36.0f, 12.0f)),
    HD_MAGMA_1(243, new Properties().setEmissive(1.0f).setDisplacement(235, 0.04f, 36.0f, 12.0f)),
    HD_MAGMA_2(244, new Properties().setEmissive(1.0f).setDisplacement(235, 0.04f, 36.0f, 12.0f)),
    BARK(245),
    WOOD_GRAIN(247),
    HD_INFERNAL_CAPE(248, new Properties().setEmissive(1.0f).setDisplacement(235, 0.02f, 12.0f, 4.0f).setScroll(0.0f, 3.0f)),
    HD_BRICK(249),
    HD_ROOF_SHINGLES_1(250, new Properties().setSpecular(0.5f, 30.0f)),
    HD_MARBLE_DARK(251, new Properties().setSpecular(1.1f, 380.0f)),
    HD_BRICK_BROWN(252),
    HD_LAVA_3(253, new Properties().setEmissive(1.0f).setDisplacement(235, 0.05f, 36.0f, 22.0f).setScroll(0.0f, 3.0f)),
    HD_ROOF_SHINGLES_2(254),
    WINTER_WILLOW_LEAVES(255, new Properties().setTextureScale(1.025f, 1.0f)),
    WINTER_MAPLE_LEAVES(256, new Properties().setTextureScale(1.3f, 1.0f)),
    WINTER_LEAVES_1(257, new Properties().setTextureScale(1.3f, 1.0f)),
    WINTER_LEAVES_2(258, new Properties().setTextureScale(1.1f, 1.1f)),
    WINTER_LEAVES_3(259),
    WINTER_PAINTING_LANDSCAPE(260),
    WINTER_PAINTING_KING(261),
    WINTER_PAINTING_ELF(262),
    WATER(7001),
    SWAMP_WATER(7025),
    POISON_WASTE(7998),
    POISON_WASTE_FLAT(998),
    BLOOD(7999),
    BLOOD_FLAT(999),
    ICE(7997),
    ICE_FLAT(997),
    CUSTOM_MATERIAL_1420(1420),
    CUSTOM_MATERIAL_1421(1421),
    CUSTOM_MATERIAL_1422(1422),
    CUSTOM_MATERIAL_1423(1423),
    CUSTOM_MATERIAL_1424(1424),
    CUSTOM_MATERIAL_1425(1425),
    CUSTOM_MATERIAL_1426(1426),
    CUSTOM_MATERIAL_1427(1427),
    CUSTOM_MATERIAL_1428(1428),
    CUSTOM_MATERIAL_1429(1429),
    CUSTOM_MATERIAL_1430(1430),
    CUSTOM_MATERIAL_1431(1431),
    CUSTOM_MATERIAL_1432(1432),
    CUSTOM_MATERIAL_1433(1433),
    CUSTOM_MATERIAL_1434(1434),
    CUSTOM_MATERIAL_1435(1435),
    CUSTOM_MATERIAL_1436(1436),
    CUSTOM_MATERIAL_1437(1437),
    CUSTOM_MATERIAL_1438(1438),
    CUSTOM_MATERIAL_1439(1439),
    CUSTOM_MATERIAL_1440(1440),
    CUSTOM_MATERIAL_1441(1441),
    CUSTOM_MATERIAL_1442(1442),
    CUSTOM_MATERIAL_1443(1443),
    CUSTOM_MATERIAL_1444(1444),
    CUSTOM_MATERIAL_1445(1445),
    CUSTOM_MATERIAL_1446(1446),
    CUSTOM_MATERIAL_1447(1447),
    CUSTOM_MATERIAL_1448(1448),
    CUSTOM_MATERIAL_1449(1449),
    CUSTOM_MATERIAL_1450(1450),
    CUSTOM_MATERIAL_1451(1451),
    CUSTOM_MATERIAL_1452(1452),
    CUSTOM_MATERIAL_1453(1453),
    CUSTOM_MATERIAL_1454(1454),
    CUSTOM_MATERIAL_1455(1455),
    CUSTOM_MATERIAL_1456(1456),
    CUSTOM_MATERIAL_1457(1457),
    CUSTOM_MATERIAL_1458(1458),
    CUSTOM_MATERIAL_1459(1459),
    CUSTOM_MATERIAL_1460(1460),
    CUSTOM_MATERIAL_1461(1461),
    CUSTOM_MATERIAL_1462(1462),
    CUSTOM_MATERIAL_1463(1463),
    CUSTOM_MATERIAL_1464(1464),
    CUSTOM_MATERIAL_1465(1465),
    CUSTOM_MATERIAL_1466(1466),
    CUSTOM_MATERIAL_1467(1467),
    CUSTOM_MATERIAL_1468(1468),
    CUSTOM_MATERIAL_1469(1469),
    CUSTOM_MATERIAL_1470(1470),
    CUSTOM_MATERIAL_1471(1471),
    CUSTOM_MATERIAL_1472(1472),
    CUSTOM_MATERIAL_1473(1473),
    CUSTOM_MATERIAL_1474(1474),
    CUSTOM_MATERIAL_1475(1475),
    CUSTOM_MATERIAL_1476(1476),
    CUSTOM_MATERIAL_1477(1477),
    CUSTOM_MATERIAL_1478(1478),
    CUSTOM_MATERIAL_1479(1479),
    CUSTOM_MATERIAL_1480(1480),
    CUSTOM_MATERIAL_1481(1481),
    CUSTOM_MATERIAL_1482(1482),
    CUSTOM_MATERIAL_1483(1483),
    CUSTOM_MATERIAL_1484(1484),
    CUSTOM_MATERIAL_1485(1485),
    CUSTOM_MATERIAL_1486(1486),
    CUSTOM_MATERIAL_1487(1487),
    CUSTOM_MATERIAL_1488(1488),
    CUSTOM_MATERIAL_1489(1489),
    CUSTOM_MATERIAL_1490(1490),
    CUSTOM_MATERIAL_1491(1491),
    CUSTOM_MATERIAL_1492(1492),
    CUSTOM_MATERIAL_1493(1493),
    CUSTOM_MATERIAL_1494(1494),
    CUSTOM_MATERIAL_1495(1495),
    CUSTOM_MATERIAL_1496(1496),
    CUSTOM_MATERIAL_1497(1497),
    CUSTOM_MATERIAL_1498(1498),
    CUSTOM_MATERIAL_1499(1499);

    private final int diffuseMapId;
    private final float specularStrength;
    private final float specularGloss;
    private final float emissiveStrength;
    private final int displacementMapId;
    private final float displacementStrength;
    private final float displacementDurationX;
    private final float displacementDurationY;
    private final float scrollDurationX;
    private final float scrollDurationY;
    private final float textureScaleX;
    private final float textureScaleY;
    private static final HashMap<Integer, Material> DIFFUSE_ID_MATERIAL_MAP;
    private static final int[] MATERIAL_DIFUSE_INDEX_MAP;
    private static final HashMap<Material, Integer> MATERIAL_INDEX_MAP;

    private Material(int diffuseMapId) {
        this.diffuseMapId = diffuseMapId;
        this.emissiveStrength = 0.0f;
        this.specularStrength = 0.0f;
        this.specularGloss = 0.0f;
        this.displacementMapId = 304;
        this.displacementStrength = 0.0f;
        this.displacementDurationX = 0.0f;
        this.displacementDurationY = 0.0f;
        this.scrollDurationX = 0.0f;
        this.scrollDurationY = 0.0f;
        this.textureScaleX = 1.0f;
        this.textureScaleY = 1.0f;
    }

    private Material(int diffuseMapId, Properties properties) {
        this.diffuseMapId = diffuseMapId;
        this.emissiveStrength = properties.emissiveStrength;
        this.specularStrength = properties.specularStrength;
        this.specularGloss = properties.specularGloss;
        this.displacementMapId = properties.displacementMapId;
        this.displacementStrength = properties.displacementStrength;
        this.displacementDurationX = properties.displacementDurationX;
        this.displacementDurationY = properties.displacementDurationY;
        this.scrollDurationX = properties.scrollDurationX;
        this.scrollDurationY = properties.scrollDurationY;
        this.textureScaleX = properties.textureScaleX;
        this.textureScaleY = properties.textureScaleY;
    }

    public static Material getTexture(int diffuseMapId) {
        return DIFFUSE_ID_MATERIAL_MAP.getOrDefault(diffuseMapId, WATER_FLAT);
    }

    public static int getIndex(Material material) {
        return MATERIAL_INDEX_MAP.getOrDefault((Object)material, 0);
    }

    public static int getIndexFromDiffuseID(int id) {
        if (id < 0 || id > 9999) {
            return 0;
        }
        return MATERIAL_DIFUSE_INDEX_MAP[id];
    }

    public static Material[] getAllTextures() {
        return Material.values();
    }

    public int getDiffuseMapId() {
        return this.diffuseMapId;
    }

    public float getSpecularStrength() {
        return this.specularStrength;
    }

    public float getSpecularGloss() {
        return this.specularGloss;
    }

    public float getEmissiveStrength() {
        return this.emissiveStrength;
    }

    public int getDisplacementMapId() {
        return this.displacementMapId;
    }

    public float getDisplacementStrength() {
        return this.displacementStrength;
    }

    public float getDisplacementDurationX() {
        return this.displacementDurationX;
    }

    public float getDisplacementDurationY() {
        return this.displacementDurationY;
    }

    public float getScrollDurationX() {
        return this.scrollDurationX;
    }

    public float getScrollDurationY() {
        return this.scrollDurationY;
    }

    public float getTextureScaleX() {
        return this.textureScaleX;
    }

    public float getTextureScaleY() {
        return this.textureScaleY;
    }

    static {
        DIFFUSE_ID_MATERIAL_MAP = new HashMap();
        MATERIAL_DIFUSE_INDEX_MAP = new int[10000];
        Arrays.fill(MATERIAL_DIFUSE_INDEX_MAP, 0);
        int index = 0;
        for (Material material : Material.values()) {
            if (!DIFFUSE_ID_MATERIAL_MAP.containsKey(material.diffuseMapId)) {
                DIFFUSE_ID_MATERIAL_MAP.put(material.diffuseMapId, material);
                if (material.diffuseMapId >= 0 && material.diffuseMapId <= 9999) {
                    Material.MATERIAL_DIFUSE_INDEX_MAP[material.diffuseMapId] = index;
                }
            }
            ++index;
        }
        MATERIAL_INDEX_MAP = new HashMap();
        index = 0;
        for (Material material : Material.values()) {
            MATERIAL_INDEX_MAP.put(material, index);
            ++index;
        }
    }

    private static class Properties {
        private float specularStrength = 0.0f;
        private float specularGloss = 0.0f;
        private float emissiveStrength = 0.0f;
        private int displacementMapId = 304;
        private float displacementStrength = 0.0f;
        private float displacementDurationX = 0.0f;
        private float displacementDurationY = 0.0f;
        private float scrollDurationX = 0.0f;
        private float scrollDurationY = 0.0f;
        private float textureScaleX = 1.0f;
        private float textureScaleY = 1.0f;

        private Properties() {
        }

        public Properties setSpecular(float specularStrength, float specularGloss) {
            this.specularStrength = specularStrength;
            this.specularGloss = specularGloss;
            return this;
        }

        public Properties setEmissive(float emissiveStrength) {
            this.emissiveStrength = emissiveStrength;
            return this;
        }

        public Properties setDisplacement(int displacementMapId, float displacementStrength, float displacementDurationX, float displacementDurationY) {
            this.displacementMapId = displacementMapId;
            this.displacementStrength = displacementStrength;
            this.displacementDurationX = displacementDurationX;
            this.displacementDurationY = displacementDurationY;
            return this;
        }

        public Properties setScroll(float scrollDurationX, float scrollDurationY) {
            this.scrollDurationX = scrollDurationX;
            this.scrollDurationY = scrollDurationY;
            return this;
        }

        public Properties setTextureScale(float textureScaleX, float textureScaleY) {
            this.textureScaleX = textureScaleX;
            this.textureScaleY = textureScaleY;
            return this;
        }
    }
}

