/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import com.google.common.base.Stopwatch;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import net.runelite.client.plugins.gpu.GpuFloatBuffer;
import net.runelite.client.plugins.gpu.GpuIntBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class SceneUploader {
    private static final Logger log = LoggerFactory.getLogger(SceneUploader.class);
    @Inject
    private Client client;
    int sceneId = (int)System.nanoTime();
    private int offset;
    private int uvoffset;

    SceneUploader() {
    }

    void upload(Scene scene, GpuIntBuffer vertexbuffer, GpuFloatBuffer uvBuffer) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ++this.sceneId;
        this.offset = 0;
        this.uvoffset = 0;
        vertexbuffer.clear();
        uvBuffer.clear();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    Tile tile = scene.getTiles()[z][x][y];
                    if (tile == null) continue;
                    this.upload(tile, vertexbuffer, uvBuffer);
                }
            }
        }
        stopwatch.stop();
        log.debug("Scene upload time: {}", (Object)stopwatch);
    }

    private void upload(Tile tile, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer) {
        GameObject[] gameObjects;
        DecorativeObject decorativeObject;
        Renderable renderable;
        GroundObject groundObject;
        WallObject wallObject;
        SceneTileModel sceneTileModel;
        SceneTilePaint sceneTilePaint;
        Tile bridge = tile.getBridge();
        if (bridge != null) {
            this.upload(bridge, vertexBuffer, uvBuffer);
        }
        if ((sceneTilePaint = tile.getSceneTilePaint()) != null) {
            sceneTilePaint.setBufferOffset(this.offset);
            if (sceneTilePaint.getTexture() != -1) {
                sceneTilePaint.setUvBufferOffset(this.uvoffset);
            } else {
                sceneTilePaint.setUvBufferOffset(-1);
            }
            Point tilePoint = tile.getSceneLocation();
            int len = this.upload(sceneTilePaint, tile.getRenderLevel(), tilePoint.getX(), tilePoint.getY(), vertexBuffer, uvBuffer, 0, 0, false);
            sceneTilePaint.setBufferLen(len);
            this.offset += len;
            if (sceneTilePaint.getTexture() != -1) {
                this.uvoffset += len;
            }
        }
        if ((sceneTileModel = tile.getSceneTileModel()) != null) {
            sceneTileModel.setBufferOffset(this.offset);
            if (sceneTileModel.getTriangleTextureId() != null) {
                sceneTileModel.setUvBufferOffset(this.uvoffset);
            } else {
                sceneTileModel.setUvBufferOffset(-1);
            }
            Point tilePoint = tile.getSceneLocation();
            int len = this.upload(sceneTileModel, tilePoint.getX(), tilePoint.getY(), vertexBuffer, uvBuffer, 0, 0, false);
            sceneTileModel.setBufferLen(len);
            this.offset += len;
            if (sceneTileModel.getTriangleTextureId() != null) {
                this.uvoffset += len;
            }
        }
        if ((wallObject = tile.getWallObject()) != null) {
            Renderable renderable2;
            Renderable renderable1 = wallObject.getRenderable1();
            if (renderable1 instanceof Model) {
                this.uploadSceneModel((Model)renderable1, vertexBuffer, uvBuffer);
            }
            if ((renderable2 = wallObject.getRenderable2()) instanceof Model) {
                this.uploadSceneModel((Model)renderable2, vertexBuffer, uvBuffer);
            }
        }
        if ((groundObject = tile.getGroundObject()) != null && (renderable = groundObject.getRenderable()) instanceof Model) {
            this.uploadSceneModel((Model)renderable, vertexBuffer, uvBuffer);
        }
        if ((decorativeObject = tile.getDecorativeObject()) != null) {
            Renderable renderable2;
            Renderable renderable3 = decorativeObject.getRenderable();
            if (renderable3 instanceof Model) {
                this.uploadSceneModel((Model)renderable3, vertexBuffer, uvBuffer);
            }
            if ((renderable2 = decorativeObject.getRenderable2()) instanceof Model) {
                this.uploadSceneModel((Model)renderable2, vertexBuffer, uvBuffer);
            }
        }
        for (GameObject gameObject : gameObjects = tile.getGameObjects()) {
            Renderable renderable4;
            if (gameObject == null || !((renderable4 = gameObject.getRenderable()) instanceof Model)) continue;
            this.uploadSceneModel((Model)gameObject.getRenderable(), vertexBuffer, uvBuffer);
        }
    }

    int upload(SceneTilePaint tile, int tileZ, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, int offsetX, int offsetY, boolean padUvs) {
        int[][][] tileHeights = this.client.getTileHeights();
        int localX = offsetX;
        int localY = offsetY;
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int neColor = tile.getNeColor();
        int nwColor = tile.getNwColor();
        int seColor = tile.getSeColor();
        int swColor = tile.getSwColor();
        if (neColor == 12345678) {
            return 0;
        }
        vertexBuffer.ensureCapacity(24);
        uvBuffer.ensureCapacity(24);
        int vertexDx = localX;
        int vertexDy = localY;
        int vertexDz = swHeight;
        int c1 = swColor;
        int vertexCx = localX + 128;
        int vertexCy = localY;
        int vertexCz = seHeight;
        int c2 = seColor;
        int vertexAx = localX + 128;
        int vertexAy = localY + 128;
        int vertexAz = neHeight;
        int c3 = neColor;
        int vertexBx = localX;
        int vertexBy = localY + 128;
        int vertexBz = nwHeight;
        int c4 = nwColor;
        vertexBuffer.put(vertexAx, vertexAz, vertexAy, c3);
        vertexBuffer.put(vertexBx, vertexBz, vertexBy, c4);
        vertexBuffer.put(vertexCx, vertexCz, vertexCy, c2);
        vertexBuffer.put(vertexDx, vertexDz, vertexDy, c1);
        vertexBuffer.put(vertexCx, vertexCz, vertexCy, c2);
        vertexBuffer.put(vertexBx, vertexBz, vertexBy, c4);
        if (padUvs || tile.getTexture() != -1) {
            float tex = (float)tile.getTexture() + 1.0f;
            uvBuffer.put(tex, 1.0f, 1.0f, 0.0f);
            uvBuffer.put(tex, 0.0f, 1.0f, 0.0f);
            uvBuffer.put(tex, 1.0f, 0.0f, 0.0f);
            uvBuffer.put(tex, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(tex, 1.0f, 0.0f, 0.0f);
            uvBuffer.put(tex, 0.0f, 1.0f, 0.0f);
        }
        return 6;
    }

    int upload(SceneTileModel sceneTileModel, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, int offsetX, int offsetY, boolean padUvs) {
        int[] faceX = sceneTileModel.getFaceX();
        int[] faceY = sceneTileModel.getFaceY();
        int[] faceZ = sceneTileModel.getFaceZ();
        int[] vertexX = sceneTileModel.getVertexX();
        int[] vertexY = sceneTileModel.getVertexY();
        int[] vertexZ = sceneTileModel.getVertexZ();
        int[] triangleColorA = sceneTileModel.getTriangleColorA();
        int[] triangleColorB = sceneTileModel.getTriangleColorB();
        int[] triangleColorC = sceneTileModel.getTriangleColorC();
        int[] triangleTextures = sceneTileModel.getTriangleTextureId();
        int faceCount = faceX.length;
        vertexBuffer.ensureCapacity(faceCount * 12);
        uvBuffer.ensureCapacity(faceCount * 12);
        int baseX = 128 * tileX;
        int baseY = 128 * tileY;
        int cnt = 0;
        for (int i = 0; i < faceCount; ++i) {
            int triangleA = faceX[i];
            int triangleB = faceY[i];
            int triangleC = faceZ[i];
            int colorA = triangleColorA[i];
            int colorB = triangleColorB[i];
            int colorC = triangleColorC[i];
            if (colorA == 12345678) continue;
            cnt += 3;
            int vertexXA = vertexX[triangleA] - baseX;
            int vertexZA = vertexZ[triangleA] - baseY;
            int vertexXB = vertexX[triangleB] - baseX;
            int vertexZB = vertexZ[triangleB] - baseY;
            int vertexXC = vertexX[triangleC] - baseX;
            int vertexZC = vertexZ[triangleC] - baseY;
            vertexBuffer.put(vertexXA + offsetX, vertexY[triangleA], vertexZA + offsetY, colorA);
            vertexBuffer.put(vertexXB + offsetX, vertexY[triangleB], vertexZB + offsetY, colorB);
            vertexBuffer.put(vertexXC + offsetX, vertexY[triangleC], vertexZC + offsetY, colorC);
            if (!padUvs && triangleTextures == null) continue;
            if (triangleTextures != null && triangleTextures[i] != -1) {
                float tex = (float)triangleTextures[i] + 1.0f;
                uvBuffer.put(tex, (float)vertexXA / 128.0f, (float)vertexZA / 128.0f, 0.0f);
                uvBuffer.put(tex, (float)vertexXB / 128.0f, (float)vertexZB / 128.0f, 0.0f);
                uvBuffer.put(tex, (float)vertexXC / 128.0f, (float)vertexZC / 128.0f, 0.0f);
                continue;
            }
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return cnt;
    }

    private void uploadSceneModel(Model model, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer) {
        if (model.getSceneId() == this.sceneId) {
            return;
        }
        model.setBufferOffset(this.offset);
        if (model.getFaceTextures() != null) {
            model.setUvBufferOffset(this.uvoffset);
        } else {
            model.setUvBufferOffset(-1);
        }
        model.setSceneId(this.sceneId);
        int len = this.pushModel(model, vertexBuffer, uvBuffer);
        this.offset += len;
        if (model.getFaceTextures() != null) {
            this.uvoffset += len;
        }
    }

    public int pushModel(Model model, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer) {
        int triangleCount = Math.min(model.getFaceCount(), 8192);
        vertexBuffer.ensureCapacity(triangleCount * 12);
        uvBuffer.ensureCapacity(triangleCount * 12);
        int[] vertexX = model.getVerticesX();
        int[] vertexY = model.getVerticesY();
        int[] vertexZ = model.getVerticesZ();
        int[] indices1 = model.getFaceIndices1();
        int[] indices2 = model.getFaceIndices2();
        int[] indices3 = model.getFaceIndices3();
        int[] color1s = model.getFaceColors1();
        int[] color2s = model.getFaceColors2();
        int[] color3s = model.getFaceColors3();
        byte[] transparencies = model.getFaceTransparencies();
        short[] faceTextures = model.getFaceTextures();
        byte[] facePriorities = model.getFaceRenderPriorities();
        float[] uv = model.getFaceTextureUVCoordinates();
        byte overrideAmount = model.getOverrideAmount();
        byte overrideHue = model.getOverrideHue();
        byte overrideSat = model.getOverrideSaturation();
        byte overrideLum = model.getOverrideLuminance();
        int len = 0;
        for (int face = 0; face < triangleCount; ++face) {
            int color1 = color1s[face];
            int color2 = color2s[face];
            int color3 = color3s[face];
            if (color3 == -1) {
                color2 = color3 = color1;
            } else if (color3 == -2) {
                vertexBuffer.put(0, 0, 0, 0);
                vertexBuffer.put(0, 0, 0, 0);
                vertexBuffer.put(0, 0, 0, 0);
                if (faceTextures != null) {
                    uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                    uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                    uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                }
                len += 3;
                continue;
            }
            if ((faceTextures == null || faceTextures[face] == -1) && overrideAmount > 0) {
                color1 = SceneUploader.interpolateHSL(color1, overrideHue, overrideSat, overrideLum, overrideAmount);
                color2 = SceneUploader.interpolateHSL(color2, overrideHue, overrideSat, overrideLum, overrideAmount);
                color3 = SceneUploader.interpolateHSL(color3, overrideHue, overrideSat, overrideLum, overrideAmount);
            }
            int packAlphaPriority = SceneUploader.packAlphaPriority(faceTextures, transparencies, facePriorities, face);
            int triangleA = indices1[face];
            int triangleB = indices2[face];
            int triangleC = indices3[face];
            vertexBuffer.put(vertexX[triangleA], vertexY[triangleA], vertexZ[triangleA], packAlphaPriority | color1);
            vertexBuffer.put(vertexX[triangleB], vertexY[triangleB], vertexZ[triangleB], packAlphaPriority | color2);
            vertexBuffer.put(vertexX[triangleC], vertexY[triangleC], vertexZ[triangleC], packAlphaPriority | color3);
            if (faceTextures != null) {
                SceneUploader.pushUvForFace(faceTextures, uv, face, uvBuffer);
            }
            len += 3;
        }
        return len;
    }

    int pushFace(Model model, int face, boolean padUvs, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, int xOffset, int yOffset, int zOffset, int orientation) {
        int z;
        int x;
        int[] vertexX = model.getVerticesX();
        int[] vertexY = model.getVerticesY();
        int[] vertexZ = model.getVerticesZ();
        int[] indices1 = model.getFaceIndices1();
        int[] indices2 = model.getFaceIndices2();
        int[] indices3 = model.getFaceIndices3();
        int[] color1s = model.getFaceColors1();
        int[] color2s = model.getFaceColors2();
        int[] color3s = model.getFaceColors3();
        byte[] transparencies = model.getFaceTransparencies();
        short[] faceTextures = model.getFaceTextures();
        byte[] facePriorities = model.getFaceRenderPriorities();
        int triangleA = indices1[face];
        int triangleB = indices2[face];
        int triangleC = indices3[face];
        int color1 = color1s[face];
        int color2 = color2s[face];
        int color3 = color3s[face];
        byte overrideAmount = model.getOverrideAmount();
        byte overrideHue = model.getOverrideHue();
        byte overrideSat = model.getOverrideSaturation();
        byte overrideLum = model.getOverrideLuminance();
        int packedAlphaPriority = SceneUploader.packAlphaPriority(faceTextures, transparencies, facePriorities, face);
        int sin = 0;
        int cos = 0;
        if (orientation != 0) {
            sin = Perspective.SINE[orientation];
            cos = Perspective.COSINE[orientation];
        }
        if (color3 == -1) {
            color2 = color3 = color1;
        } else if (color3 == -2) {
            vertexBuffer.put(0, 0, 0, 0);
            vertexBuffer.put(0, 0, 0, 0);
            vertexBuffer.put(0, 0, 0, 0);
            if (padUvs || faceTextures != null) {
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
                uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            }
            return 3;
        }
        if ((faceTextures == null || faceTextures[face] == -1) && overrideAmount > 0) {
            color1 = SceneUploader.interpolateHSL(color1, overrideHue, overrideSat, overrideLum, overrideAmount);
            color2 = SceneUploader.interpolateHSL(color2, overrideHue, overrideSat, overrideLum, overrideAmount);
            color3 = SceneUploader.interpolateHSL(color3, overrideHue, overrideSat, overrideLum, overrideAmount);
        }
        int a = vertexX[triangleA];
        int b = vertexY[triangleA];
        int c = vertexZ[triangleA];
        if (orientation != 0) {
            x = c * sin + a * cos >> 16;
            z = c * cos - a * sin >> 16;
            a = x;
            c = z;
        }
        vertexBuffer.put(a += xOffset, b += yOffset, c += zOffset, packedAlphaPriority | color1);
        a = vertexX[triangleB];
        b = vertexY[triangleB];
        c = vertexZ[triangleB];
        if (orientation != 0) {
            x = c * sin + a * cos >> 16;
            z = c * cos - a * sin >> 16;
            a = x;
            c = z;
        }
        vertexBuffer.put(a += xOffset, b += yOffset, c += zOffset, packedAlphaPriority | color2);
        a = vertexX[triangleC];
        b = vertexY[triangleC];
        c = vertexZ[triangleC];
        if (orientation != 0) {
            x = c * sin + a * cos >> 16;
            z = c * cos - a * sin >> 16;
            a = x;
            c = z;
        }
        vertexBuffer.put(a += xOffset, b += yOffset, c += zOffset, packedAlphaPriority | color3);
        if (padUvs || faceTextures != null) {
            SceneUploader.pushUvForFace(faceTextures, model.getFaceTextureUVCoordinates(), face, uvBuffer);
        }
        return 3;
    }

    private static int packAlphaPriority(short[] faceTextures, byte[] faceTransparencies, byte[] facePriorities, int face) {
        int alpha = 0;
        if (faceTransparencies != null && (faceTextures == null || faceTextures[face] == -1)) {
            alpha = (faceTransparencies[face] & 0xFF) << 24;
        }
        int priority = 0;
        if (facePriorities != null) {
            priority = (facePriorities[face] & 0xFF) << 16;
        }
        return alpha | priority;
    }

    private static void pushUvForFace(short[] faceTextures, float[] uv, int face, GpuFloatBuffer uvBuffer) {
        if (faceTextures != null && faceTextures[face] != -1 && uv != null) {
            int idx = face * 6;
            float texture = (float)faceTextures[face] + 1.0f;
            uvBuffer.put(texture, uv[idx], uv[idx + 1], 0.0f);
            uvBuffer.put(texture, uv[idx + 2], uv[idx + 3], 0.0f);
            uvBuffer.put(texture, uv[idx + 4], uv[idx + 5], 0.0f);
        } else {
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private static int interpolateHSL(int hsl, byte hue2, byte sat2, byte lum2, byte lerp) {
        int hue = hsl >> 10 & 0x3F;
        int sat = hsl >> 7 & 7;
        int lum = hsl & 0x7F;
        int var9 = lerp & 0xFF;
        if (hue2 != -1) {
            hue += var9 * (hue2 - hue) >> 7;
        }
        if (sat2 != -1) {
            sat += var9 * (sat2 - sat) >> 7;
        }
        if (lum2 != -1) {
            lum += var9 * (lum2 - lum) >> 7;
        }
        return (hue << 10 | sat << 7 | lum) & 0xFFFF;
    }
}

