/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.entityhider;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.entityhider.EntityHiderConfig;

@PluginDescriptor(name="Entity Hider", description="Hide players, NPCs, and/or projectiles", tags={"npcs", "players", "projectiles"}, enabledByDefault=false)
public class EntityHiderPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private EntityHiderConfig config;

    @Provides
    EntityHiderConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(EntityHiderConfig.class);
    }

    @Override
    protected void startUp() {
        this.updateConfig();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals("entityhider")) {
            this.updateConfig();
        }
    }

    private void updateConfig() {
        this.client.setIsHidingEntities(true);
        this.client.setOthersHidden(this.config.hideOthers());
        this.client.setOthersHidden2D(this.config.hideOthers2D());
        this.client.setFriendsHidden(this.config.hideFriends());
        this.client.setFriendsChatMembersHidden(this.config.hideFriendsChatMembers());
        this.client.setIgnoresHidden(this.config.hideIgnores());
        this.client.setLocalPlayerHidden(this.config.hideLocalPlayer());
        this.client.setLocalPlayerHidden2D(this.config.hideLocalPlayer2D());
        this.client.setNPCsHidden(this.config.hideNPCs());
        this.client.setNPCsHidden2D(this.config.hideNPCs2D());
        this.client.setPetsHidden(this.config.hidePets());
        this.client.setHitsHiddenLocal(this.config.hidePets());
        this.client.setAttackersHidden(this.config.hideAttackers());
        this.client.setProjectilesHidden(this.config.hideProjectiles());
    }

    @Override
    protected void shutDown() throws Exception {
        this.client.setIsHidingEntities(false);
        this.client.setOthersHidden(false);
        this.client.setOthersHidden2D(false);
        this.client.setFriendsHidden(false);
        this.client.setFriendsChatMembersHidden(false);
        this.client.setIgnoresHidden(false);
        this.client.setLocalPlayerHidden(false);
        this.client.setLocalPlayerHidden2D(false);
        this.client.setNPCsHidden(false);
        this.client.setNPCsHidden2D(false);
        this.client.setPetsHidden(false);
        this.client.setAttackersHidden(false);
        this.client.setProjectilesHidden(false);
    }
}

