/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.hiscore;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.runelite.client.hiscore.HiscoreEndpoint;
import net.runelite.client.hiscore.HiscoreResult;
import net.runelite.client.hiscore.HiscoreResultBuilder;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.hiscore.Skill;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiscoreClient {
    private static final Logger log = LoggerFactory.getLogger(HiscoreClient.class);
    private final OkHttpClient client;

    public HiscoreResult lookup(String username, HiscoreEndpoint endpoint) throws IOException {
        return this.lookup(username, endpoint.getHiscoreURL());
    }

    public CompletableFuture<HiscoreResult> lookupAsync(String username, HiscoreEndpoint endpoint) {
        return this.lookupAsync(username, endpoint.getHiscoreURL());
    }

    public HiscoreResult lookup(String username, HttpUrl endpoint) throws IOException {
        return this.lookupSync(username, endpoint);
    }

    public HiscoreResult lookup(String username) throws IOException {
        return this.lookup(username, HiscoreEndpoint.NORMAL);
    }

    private HiscoreResult lookupSync(String username, HttpUrl hiscoreUrl) throws IOException {
        try (Response response = this.client.newCall(HiscoreClient.buildRequest(username, hiscoreUrl)).execute();){
            HiscoreResult hiscoreResult = HiscoreClient.processResponse(username, response);
            return hiscoreResult;
        }
    }

    private CompletableFuture<HiscoreResult> lookupAsync(final String username, HttpUrl hiscoreUrl) {
        final CompletableFuture<HiscoreResult> future = new CompletableFuture<HiscoreResult>();
        this.client.newCall(HiscoreClient.buildRequest(username, hiscoreUrl)).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                try {
                    future.complete(HiscoreClient.processResponse(username, response));
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    private static Request buildRequest(String username, HttpUrl hiscoreUrl) {
        HttpUrl url = hiscoreUrl.newBuilder().addQueryParameter("player", username).build();
        log.debug("Built URL {}", (Object)url);
        return new Request.Builder().url(url).build();
    }

    private static HiscoreResult processResponse(String username, Response response) throws IOException {
        if (!response.isSuccessful()) {
            if (response.code() == 404) {
                return null;
            }
            throw new IOException("Error retrieving data from Jagex Hiscores: " + response);
        }
        String responseStr = response.body().string();
        return HiscoreClient.parseResponse(username, responseStr);
    }

    private static HiscoreResult parseResponse(String username, String responseStr) throws IOException {
        CSVParser parser = CSVParser.parse(responseStr, CSVFormat.DEFAULT);
        HiscoreResultBuilder hiscoreBuilder = new HiscoreResultBuilder(username);
        int count = 0;
        for (CSVRecord record : parser.getRecords()) {
            if (count++ >= HiscoreSkill.values().length) {
                log.warn("Jagex Hiscore API returned unexpected data");
                break;
            }
            int rank = Integer.parseInt(record.get(0));
            int level = Integer.parseInt(record.get(1));
            long experience = -1L;
            if (record.size() == 3) {
                experience = Long.parseLong(record.get(2));
            }
            Skill skill = new Skill(rank, level, experience);
            hiscoreBuilder.setNextSkill(skill);
        }
        return hiscoreBuilder.build();
    }

    public HiscoreClient(OkHttpClient client) {
        this.client = client;
    }
}

