/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.account;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.runelite.client.account.AccountClient;
import net.runelite.client.account.AccountSession;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.SessionClose;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.ws.WSClient;
import net.runelite.http.api.account.OAuthResponse;
import net.runelite.http.api.ws.messages.LoginResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private AccountSession accountSession;
    private final EventBus eventBus;
    private final ConfigManager configManager;
    private final WSClient wsClient;
    private final File sessionFile;
    private final AccountClient accountClient;
    private final Gson gson;

    @Inject
    private SessionManager(@Named(value="sessionfile") File sessionfile, ConfigManager configManager, EventBus eventBus, WSClient wsClient, AccountClient accountClient, Gson gson) {
        this.configManager = configManager;
        this.eventBus = eventBus;
        this.wsClient = wsClient;
        this.sessionFile = sessionfile;
        this.accountClient = accountClient;
        this.gson = gson;
        eventBus.register(this);
    }

    public void loadSession() {
        AccountSession session;
        if (!this.sessionFile.exists()) {
            log.info("No session file exists");
            return;
        }
        try (FileInputStream in = new FileInputStream(this.sessionFile);){
            session = this.gson.fromJson((Reader)new InputStreamReader((InputStream)in, StandardCharsets.UTF_8), AccountSession.class);
            log.debug("Loaded session for {}", (Object)session.getUsername());
        }
        catch (Exception ex) {
            log.warn("Unable to load session file", ex);
            return;
        }
        this.accountClient.setUuid(session.getUuid());
        if (!this.accountClient.sessionCheck()) {
            log.debug("Loaded session {} is invalid", (Object)session.getUuid());
            return;
        }
        this.openSession(session, false);
    }

    private void saveSession() {
        if (this.accountSession == null) {
            return;
        }
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.sessionFile), StandardCharsets.UTF_8);){
            this.gson.toJson((Object)this.accountSession, (Appendable)fw);
            log.debug("Saved session to {}", (Object)this.sessionFile);
        }
        catch (IOException ex) {
            log.warn("Unable to save session file", ex);
        }
    }

    private void deleteSession() {
        this.sessionFile.delete();
    }

    private void openSession(AccountSession session, boolean openSocket) {
        if (openSocket) {
            this.wsClient.changeSession(session.getUuid());
        }
        this.accountSession = session;
        if (session.getUsername() != null) {
            this.configManager.switchSession(session);
        }
        this.eventBus.post(new SessionOpen());
    }

    private void closeSession() {
        this.wsClient.changeSession(null);
        if (this.accountSession == null) {
            return;
        }
        log.debug("Logging out of account {}", (Object)this.accountSession.getUsername());
        this.accountClient.setUuid(this.accountSession.getUuid());
        try {
            this.accountClient.logout();
        }
        catch (IOException ex) {
            log.warn("Unable to sign out of session", ex);
        }
        this.accountSession = null;
        this.configManager.switchSession(null);
        this.eventBus.post(new SessionClose());
    }

    public void login() {
        OAuthResponse login;
        UUID uuid = this.wsClient.getSessionId() != null ? this.wsClient.getSessionId() : UUID.randomUUID();
        this.accountClient.setUuid(uuid);
        try {
            login = this.accountClient.login();
        }
        catch (IOException ex) {
            log.warn("Unable to get oauth url", ex);
            return;
        }
        this.openSession(new AccountSession(login.getUid(), Instant.now()), true);
        LinkBrowser.browse(login.getOauthUrl());
    }

    @Subscribe
    public void onLoginResponse(LoginResponse loginResponse) {
        log.debug("Now signed in as {}", (Object)loginResponse.getUsername());
        AccountSession session = this.getAccountSession();
        session.setUsername(loginResponse.getUsername());
        this.openSession(session, true);
        this.saveSession();
    }

    public void logout() {
        this.closeSession();
        this.deleteSession();
    }

    public AccountSession getAccountSession() {
        return this.accountSession;
    }
}

