/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class User
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private String email;
    @Nullable
    private String id;
    @Nullable
    private String username;
    @Nullable
    private String ipAddress;
    private @Nullable Map<String, @NotNull String> other;
    private @Nullable Map<String, @NotNull Object> unknown;

    public User() {
    }

    public User(@NotNull User user) {
        this.email = user.email;
        this.username = user.username;
        this.id = user.id;
        this.ipAddress = user.ipAddress;
        this.other = CollectionUtils.newConcurrentHashMap(user.other);
        this.unknown = CollectionUtils.newConcurrentHashMap(user.unknown);
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(@Nullable String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public @Nullable Map<String, @NotNull String> getOthers() {
        return this.other;
    }

    public void setOthers(@Nullable Map<String, @NotNull String> other) {
        this.other = CollectionUtils.newConcurrentHashMap(other);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.email != null) {
            writer.name("email").value(this.email);
        }
        if (this.id != null) {
            writer.name("id").value(this.id);
        }
        if (this.username != null) {
            writer.name("username").value(this.username);
        }
        if (this.ipAddress != null) {
            writer.name("ip_address").value(this.ipAddress);
        }
        if (this.other != null) {
            writer.name("other").value(logger, this.other);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<User> {
        @Override
        @NotNull
        public User deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            User user = new User();
            ConcurrentHashMap<String, Object> unknown = null;
            block14: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "email": {
                        user.email = reader.nextStringOrNull();
                        continue block14;
                    }
                    case "id": {
                        user.id = reader.nextStringOrNull();
                        continue block14;
                    }
                    case "username": {
                        user.username = reader.nextStringOrNull();
                        continue block14;
                    }
                    case "ip_address": {
                        user.ipAddress = reader.nextStringOrNull();
                        continue block14;
                    }
                    case "other": {
                        user.other = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block14;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            user.setUnknown(unknown);
            reader.endObject();
            return user;
        }
    }

    public static final class JsonKeys {
        public static final String EMAIL = "email";
        public static final String ID = "id";
        public static final String USERNAME = "username";
        public static final String IP_ADDRESS = "ip_address";
        public static final String OTHER = "other";
    }
}

