/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class MeasurementValue
implements JsonSerializable {
    private final float value;

    public MeasurementValue(float value) {
        this.value = value;
    }

    @TestOnly
    public float getValue() {
        return this.value;
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("value").value(this.value);
        writer.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<MeasurementValue> {
        @Override
        @NotNull
        public MeasurementValue deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            reader.nextName();
            MeasurementValue measurementValue = new MeasurementValue(reader.nextFloat().floatValue());
            reader.endObject();
            return measurementValue;
        }
    }

    public static final class JsonKeys {
        public static final String VALUE = "value";
    }
}

