/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.SpanContext;
import io.sentry.protocol.App;
import io.sentry.protocol.Browser;
import io.sentry.protocol.Device;
import io.sentry.protocol.Gpu;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.SentryRuntime;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Contexts
extends ConcurrentHashMap<String, Object>
implements JsonSerializable {
    private static final long serialVersionUID = 252445813254943011L;

    public Contexts() {
    }

    public Contexts(@NotNull Contexts contexts) {
        for (Map.Entry entry : contexts.entrySet()) {
            if (entry == null) continue;
            Object value = entry.getValue();
            if ("app".equals(entry.getKey()) && value instanceof App) {
                this.setApp(new App((App)value));
                continue;
            }
            if ("browser".equals(entry.getKey()) && value instanceof Browser) {
                this.setBrowser(new Browser((Browser)value));
                continue;
            }
            if ("device".equals(entry.getKey()) && value instanceof Device) {
                this.setDevice(new Device((Device)value));
                continue;
            }
            if ("os".equals(entry.getKey()) && value instanceof OperatingSystem) {
                this.setOperatingSystem(new OperatingSystem((OperatingSystem)value));
                continue;
            }
            if ("runtime".equals(entry.getKey()) && value instanceof SentryRuntime) {
                this.setRuntime(new SentryRuntime((SentryRuntime)value));
                continue;
            }
            if ("gpu".equals(entry.getKey()) && value instanceof Gpu) {
                this.setGpu(new Gpu((Gpu)value));
                continue;
            }
            if ("trace".equals(entry.getKey()) && value instanceof SpanContext) {
                this.setTrace(new SpanContext((SpanContext)value));
                continue;
            }
            this.put((String)entry.getKey(), value);
        }
    }

    @Nullable
    private <T> T toContextType(@NotNull String key, @NotNull Class<T> clazz) {
        Object item = this.get(key);
        return clazz.isInstance(item) ? (T)clazz.cast(item) : null;
    }

    @Nullable
    public SpanContext getTrace() {
        return this.toContextType("trace", SpanContext.class);
    }

    public void setTrace(@Nullable SpanContext traceContext) {
        Objects.requireNonNull(traceContext, "traceContext is required");
        this.put("trace", traceContext);
    }

    @Nullable
    public App getApp() {
        return this.toContextType("app", App.class);
    }

    public void setApp(@NotNull App app) {
        this.put("app", app);
    }

    @Nullable
    public Browser getBrowser() {
        return this.toContextType("browser", Browser.class);
    }

    public void setBrowser(@NotNull Browser browser) {
        this.put("browser", browser);
    }

    @Nullable
    public Device getDevice() {
        return this.toContextType("device", Device.class);
    }

    public void setDevice(@NotNull Device device) {
        this.put("device", device);
    }

    @Nullable
    public OperatingSystem getOperatingSystem() {
        return this.toContextType("os", OperatingSystem.class);
    }

    public void setOperatingSystem(@NotNull OperatingSystem operatingSystem) {
        this.put("os", operatingSystem);
    }

    @Nullable
    public SentryRuntime getRuntime() {
        return this.toContextType("runtime", SentryRuntime.class);
    }

    public void setRuntime(@NotNull SentryRuntime runtime) {
        this.put("runtime", runtime);
    }

    @Nullable
    public Gpu getGpu() {
        return this.toContextType("gpu", Gpu.class);
    }

    public void setGpu(@NotNull Gpu gpu) {
        this.put("gpu", gpu);
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        ArrayList<String> sortedKeys = Collections.list(this.keys());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            Object value = this.get(key);
            if (value == null) continue;
            writer.name(key).value(logger, value);
        }
        writer.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<Contexts> {
        @Override
        @NotNull
        public Contexts deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            Contexts contexts = new Contexts();
            reader.beginObject();
            block18: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "app": {
                        contexts.setApp(new App.Deserializer().deserialize(reader, logger));
                        continue block18;
                    }
                    case "browser": {
                        contexts.setBrowser(new Browser.Deserializer().deserialize(reader, logger));
                        continue block18;
                    }
                    case "device": {
                        contexts.setDevice(new Device.Deserializer().deserialize(reader, logger));
                        continue block18;
                    }
                    case "gpu": {
                        contexts.setGpu(new Gpu.Deserializer().deserialize(reader, logger));
                        continue block18;
                    }
                    case "os": {
                        contexts.setOperatingSystem(new OperatingSystem.Deserializer().deserialize(reader, logger));
                        continue block18;
                    }
                    case "runtime": {
                        contexts.setRuntime(new SentryRuntime.Deserializer().deserialize(reader, logger));
                        continue block18;
                    }
                    case "trace": {
                        contexts.setTrace(new SpanContext.Deserializer().deserialize(reader, logger));
                        continue block18;
                    }
                }
                Object object = reader.nextObjectOrNull();
                if (object == null) continue;
                contexts.put(nextName, object);
            }
            reader.endObject();
            return contexts;
        }
    }
}

