/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Dsn;
import io.sentry.ILogger;
import io.sentry.ITransaction;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class TraceState
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private SentryId traceId;
    @NotNull
    private String publicKey;
    @Nullable
    private String release;
    @Nullable
    private String environment;
    @Nullable
    private TraceStateUser user;
    @Nullable
    private String transaction;
    private @Nullable Map<String, @NotNull Object> unknown;

    TraceState(@NotNull SentryId traceId, @NotNull String publicKey) {
        this(traceId, publicKey, null, null, null, null);
    }

    TraceState(@NotNull SentryId traceId, @NotNull String publicKey, @Nullable String release, @Nullable String environment, @Nullable TraceStateUser user, @Nullable String transaction) {
        this.traceId = traceId;
        this.publicKey = publicKey;
        this.release = release;
        this.environment = environment;
        this.user = user;
        this.transaction = transaction;
    }

    TraceState(@NotNull ITransaction transaction, @Nullable User user, @NotNull SentryOptions sentryOptions) {
        this(transaction.getSpanContext().getTraceId(), new Dsn(sentryOptions.getDsn()).getPublicKey(), sentryOptions.getRelease(), sentryOptions.getEnvironment(), user != null ? new TraceStateUser(user) : null, transaction.getName());
    }

    @NotNull
    public SentryId getTraceId() {
        return this.traceId;
    }

    @NotNull
    public String getPublicKey() {
        return this.publicKey;
    }

    @Nullable
    public String getRelease() {
        return this.release;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    @Nullable
    public TraceStateUser getUser() {
        return this.user;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("trace_id").value(logger, this.traceId);
        writer.name("public_key").value(this.publicKey);
        if (this.release != null) {
            writer.name("release").value(this.release);
        }
        if (this.environment != null) {
            writer.name("environment").value(this.environment);
        }
        if (this.user != null && (this.user.id != null || this.user.segment != null || this.user.unknown != null)) {
            writer.name("user").value(logger, this.user);
        }
        if (this.transaction != null) {
            writer.name("transaction").value(this.transaction);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<TraceState> {
        @Override
        @NotNull
        public TraceState deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            SentryId traceId = null;
            String publicKey = null;
            String release = null;
            String environment = null;
            TraceStateUser user = null;
            String transaction = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block16: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "trace_id": {
                        traceId = new SentryId.Deserializer().deserialize(reader, logger);
                        continue block16;
                    }
                    case "public_key": {
                        publicKey = reader.nextString();
                        continue block16;
                    }
                    case "release": {
                        release = reader.nextStringOrNull();
                        continue block16;
                    }
                    case "environment": {
                        environment = reader.nextStringOrNull();
                        continue block16;
                    }
                    case "user": {
                        user = reader.nextOrNull(logger, new TraceStateUser.Deserializer());
                        continue block16;
                    }
                    case "transaction": {
                        transaction = reader.nextStringOrNull();
                        continue block16;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (traceId == null) {
                throw this.missingRequiredFieldException("trace_id", logger);
            }
            if (publicKey == null) {
                throw this.missingRequiredFieldException("public_key", logger);
            }
            TraceState traceStateUser = new TraceState(traceId, publicKey, release, environment, user, transaction);
            traceStateUser.setUnknown(unknown);
            reader.endObject();
            return traceStateUser;
        }

        private Exception missingRequiredFieldException(String field, ILogger logger) {
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            logger.log(SentryLevel.ERROR, message, exception);
            return exception;
        }
    }

    public static final class JsonKeys {
        public static final String TRACE_ID = "trace_id";
        public static final String PUBLIC_KEY = "public_key";
        public static final String RELEASE = "release";
        public static final String ENVIRONMENT = "environment";
        public static final String USER = "user";
        public static final String TRANSACTION = "transaction";
    }

    public static final class TraceStateUser
    implements JsonUnknown,
    JsonSerializable {
        @Nullable
        private String id;
        @Nullable
        private String segment;
        private @Nullable Map<String, @NotNull Object> unknown;

        TraceStateUser(@Nullable String id, @Nullable String segment) {
            this.id = id;
            this.segment = segment;
        }

        public TraceStateUser(@Nullable User protocolUser) {
            if (protocolUser != null) {
                this.id = protocolUser.getId();
                this.segment = TraceStateUser.getSegment(protocolUser);
            }
        }

        @Nullable
        private static String getSegment(@NotNull User user) {
            Map<String, String> others = user.getOthers();
            if (others != null) {
                return others.get("segment");
            }
            return null;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getSegment() {
            return this.segment;
        }

        @Override
        @Nullable
        public Map<String, Object> getUnknown() {
            return this.unknown;
        }

        @Override
        public void setUnknown(@Nullable Map<String, Object> unknown) {
            this.unknown = unknown;
        }

        @Override
        public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
            writer.beginObject();
            if (this.id != null) {
                writer.name("id").value(this.id);
            }
            if (this.segment != null) {
                writer.name("segment").value(this.segment);
            }
            if (this.unknown != null) {
                for (String key : this.unknown.keySet()) {
                    Object value = this.unknown.get(key);
                    writer.name(key);
                    writer.value(logger, value);
                }
            }
            writer.endObject();
        }

        public static final class Deserializer
        implements JsonDeserializer<TraceStateUser> {
            @Override
            @NotNull
            public TraceStateUser deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
                reader.beginObject();
                String id = null;
                String segment = null;
                ConcurrentHashMap<String, Object> unknown = null;
                block8: while (reader.peek() == JsonToken.NAME) {
                    String nextName;
                    switch (nextName = reader.nextName()) {
                        case "id": {
                            id = reader.nextStringOrNull();
                            continue block8;
                        }
                        case "segment": {
                            segment = reader.nextStringOrNull();
                            continue block8;
                        }
                    }
                    if (unknown == null) {
                        unknown = new ConcurrentHashMap<String, Object>();
                    }
                    reader.nextUnknown(logger, unknown, nextName);
                }
                TraceStateUser traceStateUser = new TraceStateUser(id, segment);
                traceStateUser.setUnknown(unknown);
                reader.endObject();
                return traceStateUser;
            }
        }

        public static final class JsonKeys {
            public static final String ID = "id";
            public static final String SEGMENT = "segment";
        }
    }
}

