/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpSpan;
import io.sentry.ProfilingTraceData;
import io.sentry.SentryLevel;
import io.sentry.SentryTraceHeader;
import io.sentry.Span;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TraceState;
import io.sentry.TraceStateHeader;
import io.sentry.TransactionContext;
import io.sentry.TransactionFinishedCallback;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryTracer
implements ITransaction {
    @NotNull
    private final SentryId eventId = new SentryId();
    @NotNull
    private final Span root;
    @NotNull
    private final List<Span> children = new CopyOnWriteArrayList<Span>();
    @NotNull
    private final IHub hub;
    @NotNull
    private String name;
    private final boolean waitForChildren;
    @NotNull
    private FinishStatus finishStatus = FinishStatus.NOT_FINISHED;
    @Nullable
    private final TransactionFinishedCallback transactionFinishedCallback;
    private final boolean trimEnd;
    @Nullable
    private final Long idleTimeout;
    @Nullable
    private TimerTask timerTask;
    @NotNull
    private final Timer timer = new Timer(true);
    @NotNull
    private final SpanByTimestampComparator spanByTimestampComparator = new SpanByTimestampComparator();
    @NotNull
    private final AtomicBoolean isFinishTimerRunning = new AtomicBoolean(false);
    @Nullable
    private TraceState traceState;

    public SentryTracer(@NotNull TransactionContext context2, @NotNull IHub hub) {
        this(context2, hub, null);
    }

    public SentryTracer(@NotNull TransactionContext context2, @NotNull IHub hub, boolean waitForChildren, @Nullable TransactionFinishedCallback transactionFinishedCallback) {
        this(context2, hub, null, waitForChildren, null, false, transactionFinishedCallback);
    }

    SentryTracer(@NotNull TransactionContext context2, @NotNull IHub hub, @Nullable Date startTimestamp) {
        this(context2, hub, startTimestamp, false, null, false, null);
    }

    SentryTracer(@NotNull TransactionContext context2, @NotNull IHub hub, @Nullable Date startTimestamp, boolean waitForChildren, @Nullable Long idleTimeout, boolean trimEnd, @Nullable TransactionFinishedCallback transactionFinishedCallback) {
        Objects.requireNonNull(context2, "context is required");
        Objects.requireNonNull(hub, "hub is required");
        this.root = new Span(context2, this, hub, startTimestamp);
        this.name = context2.getName();
        this.hub = hub;
        this.waitForChildren = waitForChildren;
        this.idleTimeout = idleTimeout;
        this.trimEnd = trimEnd;
        this.transactionFinishedCallback = transactionFinishedCallback;
        if (idleTimeout != null) {
            this.scheduleFinish(idleTimeout);
        }
    }

    @Override
    public void scheduleFinish(@NotNull Long idleTimeout) {
        this.cancelTimer();
        this.isFinishTimerRunning.set(true);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                SpanStatus status = SentryTracer.this.getStatus();
                SentryTracer.this.finish(status != null ? status : SpanStatus.OK);
                SentryTracer.this.isFinishTimerRunning.set(false);
            }
        };
        this.timer.schedule(this.timerTask, idleTimeout);
    }

    private void cancelTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.isFinishTimerRunning.set(false);
            this.timerTask = null;
        }
    }

    @NotNull
    public List<Span> getChildren() {
        return this.children;
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.root.getStartTimestamp();
    }

    @Nullable
    public Double getTimestamp() {
        return this.root.getTimestamp();
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description) {
        ISpan span = this.createChild(parentSpanId, operation);
        span.setDescription(description);
        return span;
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        return this.createChild(parentSpanId, operation, description, timestamp);
    }

    @NotNull
    private ISpan createChild(@NotNull SpanId parentSpanId, @NotNull String operation) {
        return this.createChild(parentSpanId, operation, null, null);
    }

    @NotNull
    private ISpan createChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        if (this.root.isFinished()) {
            return NoOpSpan.getInstance();
        }
        Objects.requireNonNull(parentSpanId, "parentSpanId is required");
        Objects.requireNonNull(operation, "operation is required");
        this.cancelTimer();
        Span span = new Span(this.root.getTraceId(), parentSpanId, this, operation, this.hub, timestamp, __ -> {
            FinishStatus finishStatus = this.finishStatus;
            if (this.idleTimeout != null) {
                if (!this.waitForChildren || this.hasAllChildrenFinished()) {
                    this.scheduleFinish(this.idleTimeout);
                }
            } else if (finishStatus.isFinishing) {
                this.finish(finishStatus.spanStatus);
            }
        });
        span.setDescription(description);
        this.children.add(span);
        return span;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        return this.createChild(operation, description, timestamp);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        return this.createChild(operation, description, null);
    }

    @NotNull
    private ISpan createChild(@NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        if (this.root.isFinished()) {
            return NoOpSpan.getInstance();
        }
        if (this.children.size() < this.hub.getOptions().getMaxSpans()) {
            return this.root.startChild(operation, description, timestamp);
        }
        this.hub.getOptions().getLogger().log(SentryLevel.WARNING, "Span operation: %s, description: %s dropped due to limit reached. Returning NoOpSpan.", operation, description);
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return this.root.toSentryTrace();
    }

    @Override
    public void finish() {
        this.finish(this.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        this.finishStatus = FinishStatus.finishing(status);
        if (!(this.root.isFinished() || this.waitForChildren && !this.hasAllChildrenFinished())) {
            Span oldestChild;
            Double oldestChildTimestamp;
            Long endTime;
            Double finishTimestamp;
            ProfilingTraceData profilingTraceData = null;
            Boolean isSampled = this.isSampled();
            if (isSampled == null) {
                isSampled = false;
            }
            if (this.hub.getOptions().isProfilingEnabled() && isSampled.booleanValue()) {
                profilingTraceData = this.hub.getOptions().getTransactionProfiler().onTransactionFinish(this);
            }
            if ((finishTimestamp = this.root.getHighPrecisionTimestamp(endTime = Long.valueOf(System.nanoTime()))) == null) {
                finishTimestamp = DateUtils.dateToSeconds(DateUtils.getCurrentDateTime());
                endTime = null;
            }
            for (Span child : this.children) {
                if (child.isFinished()) continue;
                child.setSpanFinishedCallback(null);
                child.finish(SpanStatus.DEADLINE_EXCEEDED, finishTimestamp, endTime);
            }
            if (!this.children.isEmpty() && this.trimEnd && (oldestChildTimestamp = (oldestChild = Collections.max(this.children, this.spanByTimestampComparator)).getTimestamp()) != null && finishTimestamp > oldestChildTimestamp) {
                finishTimestamp = oldestChildTimestamp;
                endTime = oldestChild.getEndNanos();
            }
            this.root.finish(this.finishStatus.spanStatus, finishTimestamp, endTime);
            this.hub.configureScope(scope -> scope.withTransaction(transaction -> {
                if (transaction == this) {
                    scope.clearTransaction();
                }
            }));
            SentryTransaction transaction = new SentryTransaction(this);
            if (this.transactionFinishedCallback != null) {
                this.transactionFinishedCallback.execute(this);
            }
            if (this.children.isEmpty() && this.idleTimeout != null) {
                return;
            }
            this.hub.captureTransaction(transaction, this.traceState(), null, profilingTraceData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TraceState traceState() {
        if (this.hub.getOptions().isTraceSampling()) {
            SentryTracer sentryTracer = this;
            synchronized (sentryTracer) {
                if (this.traceState == null) {
                    AtomicReference userAtomicReference = new AtomicReference();
                    this.hub.configureScope(scope -> userAtomicReference.set(scope.getUser()));
                    this.traceState = new TraceState(this, (User)userAtomicReference.get(), this.hub.getOptions());
                }
                return this.traceState;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public TraceStateHeader toTraceStateHeader() {
        TraceState traceState = this.traceState();
        if (this.hub.getOptions().isTraceSampling() && traceState != null) {
            return TraceStateHeader.fromTraceState(traceState, this.hub.getOptions().getSerializer(), this.hub.getOptions().getLogger());
        }
        return null;
    }

    private boolean hasAllChildrenFinished() {
        ArrayList<Span> spans = new ArrayList<Span>(this.children);
        if (!spans.isEmpty()) {
            for (Span span : spans) {
                if (span.isFinished()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setOperation(@NotNull String operation) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.root.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.root.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.root.getStatus();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setThrowable(throwable);
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.root.getThrowable();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.root.getSpanContext();
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return this.root.getTag(key);
    }

    @Override
    public boolean isFinished() {
        return this.root.isFinished();
    }

    @Override
    public void setData(@NotNull String key, @NotNull Object value) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setData(key, value);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String key) {
        return this.root.getData(key);
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.root.getData();
    }

    @Override
    @Nullable
    public Boolean isSampled() {
        return this.root.isSampled();
    }

    @Override
    public void setName(@NotNull String name) {
        if (this.root.isFinished()) {
            return;
        }
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Span> getSpans() {
        return this.children;
    }

    @Override
    @Nullable
    public Span getLatestActiveSpan() {
        ArrayList<Span> spans = new ArrayList<Span>(this.children);
        if (!spans.isEmpty()) {
            for (int i = spans.size() - 1; i >= 0; --i) {
                if (((Span)spans.get(i)).isFinished()) continue;
                return (Span)spans.get(i);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SentryId getEventId() {
        return this.eventId;
    }

    @Nullable
    public Double getHighPrecisionTimestamp() {
        return this.root.getHighPrecisionTimestamp();
    }

    @NotNull
    Span getRoot() {
        return this.root;
    }

    @TestOnly
    @Nullable
    TimerTask getTimerTask() {
        return this.timerTask;
    }

    @TestOnly
    @NotNull
    AtomicBoolean isFinishTimerRunning() {
        return this.isFinishTimerRunning;
    }

    private static final class SpanByTimestampComparator
    implements Comparator<Span> {
        private SpanByTimestampComparator() {
        }

        @Override
        public int compare(Span o1, Span o2) {
            Double first = o1.getHighPrecisionTimestamp();
            Double second = o2.getHighPrecisionTimestamp();
            if (first == null) {
                return -1;
            }
            if (second == null) {
                return 1;
            }
            return first.compareTo(second);
        }
    }

    private static final class FinishStatus {
        static final FinishStatus NOT_FINISHED = FinishStatus.notFinished();
        private final boolean isFinishing;
        @Nullable
        private final SpanStatus spanStatus;

        @NotNull
        static FinishStatus finishing(@Nullable SpanStatus finishStatus) {
            return new FinishStatus(true, finishStatus);
        }

        @NotNull
        private static FinishStatus notFinished() {
            return new FinishStatus(false, null);
        }

        private FinishStatus(boolean isFinishing, @Nullable SpanStatus spanStatus) {
            this.isFinishing = isFinishing;
            this.spanStatus = spanStatus;
        }
    }
}

