/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.TraceState;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryId;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryEnvelopeHeader
implements JsonSerializable,
JsonUnknown {
    @Nullable
    private final SentryId eventId;
    @Nullable
    private final SdkVersion sdkVersion;
    @Nullable
    private final TraceState trace;
    @Nullable
    private Map<String, Object> unknown;

    public SentryEnvelopeHeader(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion) {
        this(eventId, sdkVersion, null);
    }

    public SentryEnvelopeHeader(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion, @Nullable TraceState trace) {
        this.eventId = eventId;
        this.sdkVersion = sdkVersion;
        this.trace = trace;
    }

    public SentryEnvelopeHeader(@Nullable SentryId eventId) {
        this(eventId, null);
    }

    public SentryEnvelopeHeader() {
        this(new SentryId());
    }

    @Nullable
    public SentryId getEventId() {
        return this.eventId;
    }

    @Nullable
    public SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public TraceState getTrace() {
        return this.trace;
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.eventId != null) {
            writer.name("event_id").value(logger, this.eventId);
        }
        if (this.sdkVersion != null) {
            writer.name("sdk").value(logger, this.sdkVersion);
        }
        if (this.trace != null) {
            writer.name("trace").value(logger, this.trace);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEnvelopeHeader> {
        @Override
        @NotNull
        public SentryEnvelopeHeader deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            SentryId eventId = null;
            SdkVersion sdkVersion = null;
            TraceState trace = null;
            HashMap<String, Object> unknown = null;
            block10: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "event_id": {
                        eventId = reader.nextOrNull(logger, new SentryId.Deserializer());
                        continue block10;
                    }
                    case "sdk": {
                        sdkVersion = reader.nextOrNull(logger, new SdkVersion.Deserializer());
                        continue block10;
                    }
                    case "trace": {
                        trace = reader.nextOrNull(logger, new TraceState.Deserializer());
                        continue block10;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            SentryEnvelopeHeader sentryEnvelopeHeader = new SentryEnvelopeHeader(eventId, sdkVersion, trace);
            sentryEnvelopeHeader.setUnknown(unknown);
            reader.endObject();
            return sentryEnvelopeHeader;
        }
    }

    public static final class JsonKeys {
        public static final String EVENT_ID = "event_id";
        public static final String SDK = "sdk";
        public static final String TRACE = "trace";
    }
}

