/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectDeserializer;
import io.sentry.SentryLevel;
import io.sentry.vendor.gson.stream.JsonReader;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JsonObjectReader
extends JsonReader {
    public JsonObjectReader(Reader in) {
        super(in);
    }

    @Nullable
    public String nextStringOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextString();
    }

    @Nullable
    public Double nextDoubleOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextDouble();
    }

    @Nullable
    public Float nextFloatOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextFloat();
    }

    @NotNull
    public Float nextFloat() throws IOException {
        return Float.valueOf((float)this.nextDouble());
    }

    @Nullable
    public Long nextLongOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextLong();
    }

    @Nullable
    public Integer nextIntegerOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextInt();
    }

    @Nullable
    public Boolean nextBooleanOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextBoolean();
    }

    public void nextUnknown(ILogger logger, Map<String, Object> unknown, String name) {
        try {
            unknown.put(name, this.nextObjectOrNull());
        }
        catch (Exception exception) {
            logger.log(SentryLevel.ERROR, exception, "Error deserializing unknown key: %s", name);
        }
    }

    @Nullable
    public <T> List<T> nextList(@NotNull ILogger logger, @NotNull JsonDeserializer<T> deserializer) throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        this.beginArray();
        ArrayList<T> list = new ArrayList<T>();
        do {
            try {
                list.add(deserializer.deserialize(this, logger));
            }
            catch (Exception e) {
                logger.log(SentryLevel.ERROR, "Failed to deserialize object in list.", e);
            }
        } while (this.peek() == JsonToken.BEGIN_OBJECT);
        this.endArray();
        return list;
    }

    @Nullable
    public <T> T nextOrNull(@NotNull ILogger logger, @NotNull JsonDeserializer<T> deserializer) throws Exception {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return deserializer.deserialize(this, logger);
    }

    @Nullable
    public Date nextDateOrNull(ILogger logger) throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        String dateString = this.nextString();
        try {
            return DateUtils.getDateTime(dateString);
        }
        catch (Exception e) {
            logger.log(SentryLevel.DEBUG, "Error when deserializing UTC timestamp format, it might be millis timestamp format.", e);
            try {
                return DateUtils.getDateTimeWithMillisPrecision(dateString);
            }
            catch (Exception e2) {
                logger.log(SentryLevel.ERROR, "Error when deserializing millis timestamp format.", e2);
                return null;
            }
        }
    }

    @Nullable
    public TimeZone nextTimeZoneOrNull(ILogger logger) throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        try {
            return TimeZone.getTimeZone(this.nextString());
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Error when deserializing TimeZone", e);
            return null;
        }
    }

    @Nullable
    public Object nextObjectOrNull() throws IOException {
        return new JsonObjectDeserializer().deserialize(this);
    }
}

