/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWindowSubscribeIntercept;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableWindow<T>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final long count;
    final long skip;
    final int capacityHint;

    public ObservableWindow(ObservableSource<T> source2, long count, long skip, int capacityHint) {
        super(source2);
        this.count = count;
        this.skip = skip;
        this.capacityHint = capacityHint;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> t) {
        if (this.count == this.skip) {
            this.source.subscribe(new WindowExactObserver(t, this.count, this.capacityHint));
        } else {
            this.source.subscribe(new WindowSkipObserver(t, this.count, this.skip, this.capacityHint));
        }
    }

    static final class WindowSkipObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 3366976432059579510L;
        final Observer<? super Observable<T>> downstream;
        final long count;
        final long skip;
        final int capacityHint;
        final ArrayDeque<UnicastSubject<T>> windows;
        final AtomicBoolean cancelled;
        long index;
        long firstEmission;
        Disposable upstream;

        WindowSkipObserver(Observer<? super Observable<T>> actual, long count, long skip, int capacityHint) {
            this.downstream = actual;
            this.count = count;
            this.skip = skip;
            this.capacityHint = capacityHint;
            this.windows = new ArrayDeque();
            this.cancelled = new AtomicBoolean();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            ArrayDeque<UnicastSubject<T>> ws = this.windows;
            long i = this.index;
            long s2 = this.skip;
            ObservableWindowSubscribeIntercept intercept = null;
            if (i % s2 == 0L && !this.cancelled.get()) {
                this.getAndIncrement();
                UnicastSubject w = UnicastSubject.create(this.capacityHint, this);
                intercept = new ObservableWindowSubscribeIntercept(w);
                ws.offer(w);
                this.downstream.onNext(intercept);
            }
            long c = this.firstEmission + 1L;
            for (UnicastSubject<T> w : ws) {
                w.onNext(t);
            }
            if (c >= this.count) {
                ws.poll().onComplete();
                if (ws.isEmpty() && this.cancelled.get()) {
                    return;
                }
                this.firstEmission = c - s2;
            } else {
                this.firstEmission = c;
            }
            this.index = i + 1L;
            if (intercept != null && intercept.tryAbandon()) {
                intercept.window.onComplete();
            }
        }

        @Override
        public void onError(Throwable t) {
            ArrayDeque<UnicastSubject<T>> ws = this.windows;
            while (!ws.isEmpty()) {
                ws.poll().onError(t);
            }
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            ArrayDeque<UnicastSubject<T>> ws = this.windows;
            while (!ws.isEmpty()) {
                ws.poll().onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }
    }

    static final class WindowExactObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -7481782523886138128L;
        final Observer<? super Observable<T>> downstream;
        final long count;
        final int capacityHint;
        final AtomicBoolean cancelled;
        long size;
        Disposable upstream;
        UnicastSubject<T> window;

        WindowExactObserver(Observer<? super Observable<T>> actual, long count, int capacityHint) {
            this.downstream = actual;
            this.count = count;
            this.capacityHint = capacityHint;
            this.cancelled = new AtomicBoolean();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            UnicastSubject<T> w = this.window;
            ObservableWindowSubscribeIntercept<T> intercept = null;
            if (w == null && !this.cancelled.get()) {
                this.getAndIncrement();
                w = UnicastSubject.create(this.capacityHint, this);
                this.window = w;
                intercept = new ObservableWindowSubscribeIntercept<T>(w);
                this.downstream.onNext(intercept);
            }
            if (w != null) {
                w.onNext(t);
                if (++this.size >= this.count) {
                    this.size = 0L;
                    this.window = null;
                    w.onComplete();
                }
                if (intercept != null && intercept.tryAbandon()) {
                    this.window = null;
                    w.onComplete();
                    w = null;
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            UnicastSubject<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            UnicastSubject<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }
    }
}

