/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableScalarXMap {
    private ObservableScalarXMap() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, R> boolean tryScalarXMapSubscribe(ObservableSource<T> source2, Observer<? super R> observer, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        if (source2 instanceof Supplier) {
            ObservableSource<R> r;
            Object t;
            try {
                t = ((Supplier)((Object)source2)).get();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, observer);
                return true;
            }
            if (t == null) {
                EmptyDisposable.complete(observer);
                return true;
            }
            try {
                r = Objects.requireNonNull(mapper.apply(t), "The mapper returned a null ObservableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, observer);
                return true;
            }
            if (r instanceof Supplier) {
                Object u;
                try {
                    u = ((Supplier)((Object)r)).get();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    EmptyDisposable.error(ex, observer);
                    return true;
                }
                if (u == null) {
                    EmptyDisposable.complete(observer);
                    return true;
                }
                ScalarDisposable<R> sd = new ScalarDisposable<R>(observer, u);
                observer.onSubscribe(sd);
                sd.run();
            } else {
                r.subscribe(observer);
            }
            return true;
        }
        return false;
    }

    public static <T, U> Observable<U> scalarXMap(T value, Function<? super T, ? extends ObservableSource<? extends U>> mapper) {
        return RxJavaPlugins.onAssembly(new ScalarXMapObservable(value, mapper));
    }

    public static final class ScalarDisposable<T>
    extends AtomicInteger
    implements QueueDisposable<T>,
    Runnable {
        private static final long serialVersionUID = 3880992722410194083L;
        final Observer<? super T> observer;
        final T value;
        static final int START = 0;
        static final int FUSED = 1;
        static final int ON_NEXT = 2;
        static final int ON_COMPLETE = 3;

        public ScalarDisposable(Observer<? super T> observer, T value) {
            this.observer = observer;
            this.value = value;
        }

        @Override
        public boolean offer(T value) {
            throw new UnsupportedOperationException("Should not be called!");
        }

        @Override
        public boolean offer(T v1, T v2) {
            throw new UnsupportedOperationException("Should not be called!");
        }

        @Override
        @Nullable
        public T poll() {
            if (this.get() == 1) {
                this.lazySet(3);
                return this.value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.get() != 1;
        }

        @Override
        public void clear() {
            this.lazySet(3);
        }

        @Override
        public void dispose() {
            this.set(3);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == 3;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.lazySet(1);
                return 1;
            }
            return 0;
        }

        @Override
        public void run() {
            if (this.get() == 0 && this.compareAndSet(0, 2)) {
                this.observer.onNext(this.value);
                if (this.get() == 2) {
                    this.lazySet(3);
                    this.observer.onComplete();
                }
            }
        }
    }

    static final class ScalarXMapObservable<T, R>
    extends Observable<R> {
        final T value;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;

        ScalarXMapObservable(T value, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
            this.value = value;
            this.mapper = mapper;
        }

        @Override
        public void subscribeActual(Observer<? super R> observer) {
            ObservableSource<R> other;
            try {
                other = Objects.requireNonNull(this.mapper.apply(this.value), "The mapper returned a null ObservableSource");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptyDisposable.error(e, observer);
                return;
            }
            if (other instanceof Supplier) {
                Object u;
                try {
                    u = ((Supplier)((Object)other)).get();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    EmptyDisposable.error(ex, observer);
                    return;
                }
                if (u == null) {
                    EmptyDisposable.complete(observer);
                    return;
                }
                ScalarDisposable<R> sd = new ScalarDisposable<R>(observer, u);
                observer.onSubscribe(sd);
                sd.run();
            } else {
                other.subscribe(observer);
            }
        }
    }
}

