/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxrelay3;

import com.jakewharton.rxrelay3.Relay;
import io.reactivex.rxjava3.functions.Predicate;

class AppendOnlyLinkedArrayList<T> {
    private final int capacity;
    private final Object[] head;
    private Object[] tail;
    private int offset;

    AppendOnlyLinkedArrayList(int capacity) {
        this.capacity = capacity;
        this.head = new Object[capacity + 1];
        this.tail = this.head;
    }

    void add(T value) {
        int o = this.offset;
        int c = this.capacity;
        if (o == c) {
            Object[] next;
            this.tail[c] = next = new Object[c + 1];
            this.tail = next;
            o = 0;
        }
        this.tail[o] = value;
        this.offset = o + 1;
    }

    void forEachWhile(NonThrowingPredicate<? super T> consumer) {
        Object[] a = this.head;
        int c = this.capacity;
        while (a != null) {
            Object o;
            for (int i = 0; i < c && (o = a[i]) != null && !consumer.test(o); ++i) {
            }
            a = (Object[])a[c];
        }
    }

    void accept(Relay<? super T> observer) {
        Object[] a = this.head;
        int c = this.capacity;
        while (a != null) {
            Object o;
            for (int i = 0; i < c && (o = a[i]) != null; ++i) {
                observer.accept(o);
            }
            a = (Object[])a[c];
        }
    }

    public static interface NonThrowingPredicate<T>
    extends Predicate<T> {
        @Override
        public boolean test(T var1);
    }
}

